package io.github.vigoo.zioaws.costexplorer.model
import zio.ZIO
import io.github.vigoo.zioaws.costexplorer.model.primitives.NextPageToken
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetAnomalyMonitorsResponse(
    anomalyMonitors: Iterable[
      io.github.vigoo.zioaws.costexplorer.model.AnomalyMonitor
    ],
    nextPageToken: Option[NextPageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.costexplorer.model.GetAnomalyMonitorsResponse = {
    import GetAnomalyMonitorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetAnomalyMonitorsResponse
      .builder()
      .anomalyMonitors(anomalyMonitors.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.costexplorer.model.GetAnomalyMonitorsResponse.ReadOnly =
    io.github.vigoo.zioaws.costexplorer.model.GetAnomalyMonitorsResponse
      .wrap(buildAwsValue())
}
object GetAnomalyMonitorsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.costexplorer.model.GetAnomalyMonitorsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.costexplorer.model.GetAnomalyMonitorsResponse =
      io.github.vigoo.zioaws.costexplorer.model.GetAnomalyMonitorsResponse(
        anomalyMonitorsValue.map { item =>
          item.editable
        },
        nextPageTokenValue.map(value => value)
      )
    def anomalyMonitorsValue: List[
      io.github.vigoo.zioaws.costexplorer.model.AnomalyMonitor.ReadOnly
    ]
    def nextPageTokenValue: Option[NextPageToken]
    def anomalyMonitors: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.costexplorer.model.AnomalyMonitor.ReadOnly
    ]] = ZIO.succeed(anomalyMonitorsValue)
    def nextPageToken: ZIO[Any, AwsError, NextPageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.costexplorer.model.GetAnomalyMonitorsResponse
  ) extends io.github.vigoo.zioaws.costexplorer.model.GetAnomalyMonitorsResponse.ReadOnly {
    override def anomalyMonitorsValue: List[
      io.github.vigoo.zioaws.costexplorer.model.AnomalyMonitor.ReadOnly
    ] = impl
      .anomalyMonitors()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.costexplorer.model.AnomalyMonitor.wrap(item)
      }
      .toList
    override def nextPageTokenValue: Option[NextPageToken] =
      scala.Option(impl.nextPageToken()).map(value => value: NextPageToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.costexplorer.model.GetAnomalyMonitorsResponse
  ): io.github.vigoo.zioaws.costexplorer.model.GetAnomalyMonitorsResponse.ReadOnly =
    new Wrapper(impl)
}
