package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetDimensionValuesRequest(searchString: scala.Option[primitives.SearchString] = None, timePeriod: DateInterval, dimension: Dimension, context: scala.Option[Context] = None, filter: scala.Option[Expression] = None, sortBy: scala.Option[Iterable[SortDefinition]] = None, maxResults: scala.Option[primitives.MaxResults] = None, nextPageToken: scala.Option[primitives.NextPageToken] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.GetDimensionValuesRequest = {
    import GetDimensionValuesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetDimensionValuesRequest.builder().optionallyWith(searchString.map(value => value: java.lang.String))(_.searchString).timePeriod(timePeriod.buildAwsValue()).dimension(dimension.unwrap).optionallyWith(context.map(value => value.unwrap))(_.context).optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter).optionallyWith(sortBy.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.sortBy).optionallyWith(maxResults.map(value => value: java.lang.Integer))(_.maxResults).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).build()
  }
  def asReadOnly: GetDimensionValuesRequest.ReadOnly = GetDimensionValuesRequest.wrap(buildAwsValue())
}
object GetDimensionValuesRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.GetDimensionValuesRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetDimensionValuesRequest = GetDimensionValuesRequest(searchStringValue.map(value => value), timePeriodValue.editable, dimensionValue, contextValue.map(value => value), filterValue.map(value => value.editable), sortByValue.map(value => value.map { item => 
      item.editable
    }), maxResultsValue.map(value => value), nextPageTokenValue.map(value => value))
    def searchStringValue: scala.Option[primitives.SearchString]
    def timePeriodValue: DateInterval.ReadOnly
    def dimensionValue: Dimension
    def contextValue: scala.Option[Context]
    def filterValue: scala.Option[Expression.ReadOnly]
    def sortByValue: scala.Option[List[SortDefinition.ReadOnly]]
    def maxResultsValue: scala.Option[primitives.MaxResults]
    def nextPageTokenValue: scala.Option[primitives.NextPageToken]
    def searchString: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.SearchString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("searchString", searchStringValue)
    def timePeriod: ZIO[Any, Nothing, DateInterval.ReadOnly] = ZIO.succeed(timePeriodValue)
    def dimension: ZIO[Any, Nothing, Dimension] = ZIO.succeed(dimensionValue)
    def context: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Context] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("context", contextValue)
    def filter: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Expression.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filter", filterValue)
    def sortBy: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[SortDefinition.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sortBy", sortByValue)
    def maxResults: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MaxResults] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextPageToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.GetDimensionValuesRequest) extends GetDimensionValuesRequest.ReadOnly {
    override def searchStringValue: scala.Option[primitives.SearchString] = scala.Option(impl.searchString()).map(value => value: primitives.SearchString)
    override def timePeriodValue: DateInterval.ReadOnly = DateInterval.wrap(impl.timePeriod())
    override def dimensionValue: Dimension = Dimension.wrap(impl.dimension())
    override def contextValue: scala.Option[Context] = scala.Option(impl.context()).map(value => Context.wrap(value))
    override def filterValue: scala.Option[Expression.ReadOnly] = scala.Option(impl.filter()).map(value => Expression.wrap(value))
    override def sortByValue: scala.Option[List[SortDefinition.ReadOnly]] = scala.Option(impl.sortBy()).map(value => value.asScala.map { item => 
      SortDefinition.wrap(item)
    }.toList)
    override def maxResultsValue: scala.Option[primitives.MaxResults] = scala.Option(impl.maxResults()).map(value => value: primitives.MaxResults)
    override def nextPageTokenValue: scala.Option[primitives.NextPageToken] = scala.Option(impl.nextPageToken()).map(value => value: primitives.NextPageToken)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.GetDimensionValuesRequest): ReadOnly = new Wrapper(impl)
}