package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CostCategoryProcessingStatus(component: scala.Option[CostCategoryStatusComponent] = None, status: scala.Option[CostCategoryStatus] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.CostCategoryProcessingStatus = {
    import CostCategoryProcessingStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.CostCategoryProcessingStatus.builder().optionallyWith(component.map(value => value.unwrap))(_.component).optionallyWith(status.map(value => value.unwrap))(_.status).build()
  }
  def asReadOnly: CostCategoryProcessingStatus.ReadOnly = CostCategoryProcessingStatus.wrap(buildAwsValue())
}
object CostCategoryProcessingStatus {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.CostCategoryProcessingStatus] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CostCategoryProcessingStatus = CostCategoryProcessingStatus(componentValue.map(value => value), statusValue.map(value => value))
    def componentValue: scala.Option[CostCategoryStatusComponent]
    def statusValue: scala.Option[CostCategoryStatus]
    def component: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, CostCategoryStatusComponent] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("component", componentValue)
    def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, CostCategoryStatus] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.CostCategoryProcessingStatus) extends CostCategoryProcessingStatus.ReadOnly {
    override def componentValue: scala.Option[CostCategoryStatusComponent] = scala.Option(impl.component()).map(value => CostCategoryStatusComponent.wrap(value))
    override def statusValue: scala.Option[CostCategoryStatus] = scala.Option(impl.status()).map(value => CostCategoryStatus.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.CostCategoryProcessingStatus): ReadOnly = new Wrapper(impl)
}