package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class AnomalySubscription(subscriptionArn: scala.Option[primitives.GenericString] = None, accountId: scala.Option[primitives.GenericString] = None, monitorArnList: Iterable[primitives.Arn], subscribers: Iterable[Subscriber], threshold: primitives.NullableNonNegativeDouble, frequency: AnomalySubscriptionFrequency, subscriptionName: primitives.GenericString) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.AnomalySubscription = {
    import AnomalySubscription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.AnomalySubscription.builder().optionallyWith(subscriptionArn.map(value => value: java.lang.String))(_.subscriptionArn).optionallyWith(accountId.map(value => value: java.lang.String))(_.accountId).monitorArnList(monitorArnList.map { item => 
      item: java.lang.String
    }.asJavaCollection).subscribers(subscribers.map { item => 
      item.buildAwsValue()
    }.asJavaCollection).threshold(threshold: java.lang.Double).frequency(frequency.unwrap).subscriptionName(subscriptionName: java.lang.String).build()
  }
  def asReadOnly: AnomalySubscription.ReadOnly = AnomalySubscription.wrap(buildAwsValue())
}
object AnomalySubscription {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.AnomalySubscription] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: AnomalySubscription = AnomalySubscription(subscriptionArnValue.map(value => value), accountIdValue.map(value => value), monitorArnListValue, subscribersValue.map { item => 
      item.editable
    }, thresholdValue, frequencyValue, subscriptionNameValue)
    def subscriptionArnValue: scala.Option[primitives.GenericString]
    def accountIdValue: scala.Option[primitives.GenericString]
    def monitorArnListValue: List[primitives.Arn]
    def subscribersValue: List[Subscriber.ReadOnly]
    def thresholdValue: primitives.NullableNonNegativeDouble
    def frequencyValue: AnomalySubscriptionFrequency
    def subscriptionNameValue: primitives.GenericString
    def subscriptionArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("subscriptionArn", subscriptionArnValue)
    def accountId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("accountId", accountIdValue)
    def monitorArnList: ZIO[Any, Nothing, List[primitives.Arn]] = ZIO.succeed(monitorArnListValue)
    def subscribers: ZIO[Any, Nothing, List[Subscriber.ReadOnly]] = ZIO.succeed(subscribersValue)
    def threshold: ZIO[Any, Nothing, primitives.NullableNonNegativeDouble] = ZIO.succeed(thresholdValue)
    def frequency: ZIO[Any, Nothing, AnomalySubscriptionFrequency] = ZIO.succeed(frequencyValue)
    def subscriptionName: ZIO[Any, Nothing, primitives.GenericString] = ZIO.succeed(subscriptionNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.AnomalySubscription) extends AnomalySubscription.ReadOnly {
    override def subscriptionArnValue: scala.Option[primitives.GenericString] = scala.Option(impl.subscriptionArn()).map(value => value: primitives.GenericString)
    override def accountIdValue: scala.Option[primitives.GenericString] = scala.Option(impl.accountId()).map(value => value: primitives.GenericString)
    override def monitorArnListValue: List[primitives.Arn] = impl.monitorArnList().asScala.map { item => 
      item: primitives.Arn
    }.toList
    override def subscribersValue: List[Subscriber.ReadOnly] = impl.subscribers().asScala.map { item => 
      Subscriber.wrap(item)
    }.toList
    override def thresholdValue: primitives.NullableNonNegativeDouble = impl.threshold(): primitives.NullableNonNegativeDouble
    override def frequencyValue: AnomalySubscriptionFrequency = AnomalySubscriptionFrequency.wrap(impl.frequency())
    override def subscriptionNameValue: primitives.GenericString = impl.subscriptionName(): primitives.GenericString
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.AnomalySubscription): ReadOnly = new Wrapper(impl)
}