package io.github.vigoo.zioaws.costexplorer
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
package object model {
  object primitives {
    type AmortizedRecurringFee = String
    type AmortizedUpfrontFee = String
    type Arn = String
    type AttributeType = String
    type AttributeValue = String
    type CostCategoryMaxResults = Int
    type CostCategoryName = String
    type CostCategoryValue = String
    type CoverageHoursPercentage = String
    type CoverageNormalizedUnitsPercentage = String
    type Entity = String
    type Estimated = Boolean
    type GenericBoolean = Boolean
    type GenericDouble = Double
    type GenericString = String
    type GroupDefinitionKey = String
    type Key = String
    type MaxResults = Int
    type MetricAmount = String
    type MetricName = String
    type MetricUnit = String
    type NetRISavings = String
    type NextPageToken = String
    type NonNegativeInteger = Int
    type NullableNonNegativeDouble = Double
    type OnDemandCost = String
    type OnDemandCostOfRIHoursUsed = String
    type OnDemandHours = String
    type OnDemandNormalizedUnits = String
    type PageSize = Int
    type PredictionIntervalLevel = Int
    type PurchasedHours = String
    type PurchasedUnits = String
    type RICostForUnusedHours = String
    type RealizedSavings = String
    type ReservationGroupKey = String
    type ReservationGroupValue = String
    type ReservedHours = String
    type ReservedNormalizedUnits = String
    type SavingsPlanArn = String
    type SearchString = String
    type SortDefinitionKey = String
    type SubscriberAddress = String
    type TagKey = String
    type TotalActualHours = String
    type TotalActualUnits = String
    type TotalAmortizedFee = String
    type TotalPotentialRISavings = String
    type TotalRunningHours = String
    type TotalRunningNormalizedUnits = String
    type UnrealizedSavings = String
    type UnusedHours = String
    type UnusedUnits = String
    type UtilizationPercentage = String
    type UtilizationPercentageInUnits = String
    type Value = String
    type YearMonthDay = String
    type ZonedDateTime = String
  }
  type Anomalies = List[Anomaly]
  type AnomalyMonitors = List[AnomalyMonitor]
  type AnomalySubscriptions = List[AnomalySubscription]
  type Attributes = Map[primitives.AttributeType, primitives.AttributeValue]
  type CostCategoryNamesList = List[primitives.CostCategoryName]
  type CostCategoryProcessingStatusList = List[CostCategoryProcessingStatus]
  type CostCategoryReferencesList = List[CostCategoryReference]
  type CostCategoryRulesList = List[CostCategoryRule]
  type CostCategoryValuesList = List[primitives.CostCategoryValue]
  type CoveragesByTime = List[CoverageByTime]
  type DimensionValuesWithAttributesList = List[DimensionValuesWithAttributes]
  type Expressions = List[Expression]
  type FindingReasonCodes = List[FindingReasonCode]
  type ForecastResultsByTime = List[ForecastResult]
  type GroupDefinitions = List[GroupDefinition]
  type Groups = List[Group]
  type Keys = List[primitives.Key]
  type MatchOptions = List[MatchOption]
  type MetricNames = List[primitives.MetricName]
  type Metrics = Map[primitives.MetricName, MetricValue]
  type MonitorArnList = List[primitives.Arn]
  type PlatformDifferences = List[PlatformDifference]
  type ReservationCoverageGroups = List[ReservationCoverageGroup]
  type ReservationPurchaseRecommendationDetails = List[ReservationPurchaseRecommendationDetail]
  type ReservationPurchaseRecommendations = List[ReservationPurchaseRecommendation]
  type ReservationUtilizationGroups = List[ReservationUtilizationGroup]
  type ResultsByTime = List[ResultByTime]
  type RightsizingRecommendationList = List[RightsizingRecommendation]
  type RootCauses = List[RootCause]
  type SavingsPlansCoverages = List[SavingsPlansCoverage]
  type SavingsPlansDataTypes = List[SavingsPlansDataType]
  type SavingsPlansPurchaseRecommendationDetailList = List[SavingsPlansPurchaseRecommendationDetail]
  type SavingsPlansUtilizationDetails = List[SavingsPlansUtilizationDetail]
  type SavingsPlansUtilizationsByTime = List[SavingsPlansUtilizationByTime]
  type SortDefinitions = List[SortDefinition]
  type Subscribers = List[Subscriber]
  type TagList = List[primitives.Entity]
  type TagValuesList = List[TagValues]
  type TargetInstancesList = List[TargetInstance]
  type UtilizationsByTime = List[UtilizationByTime]
  type Values = List[primitives.Value]
}