package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class UpdateCostCategoryDefinitionResponse(costCategoryArn: scala.Option[primitives.Arn] = None, effectiveStart: scala.Option[primitives.ZonedDateTime] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.UpdateCostCategoryDefinitionResponse = {
    import UpdateCostCategoryDefinitionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.UpdateCostCategoryDefinitionResponse.builder().optionallyWith(costCategoryArn.map(value => value: java.lang.String))(_.costCategoryArn).optionallyWith(effectiveStart.map(value => value: java.lang.String))(_.effectiveStart).build()
  }
  def asReadOnly: UpdateCostCategoryDefinitionResponse.ReadOnly = UpdateCostCategoryDefinitionResponse.wrap(buildAwsValue())
}
object UpdateCostCategoryDefinitionResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.UpdateCostCategoryDefinitionResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: UpdateCostCategoryDefinitionResponse = UpdateCostCategoryDefinitionResponse(costCategoryArnValue.map(value => value), effectiveStartValue.map(value => value))
    def costCategoryArnValue: scala.Option[primitives.Arn]
    def effectiveStartValue: scala.Option[primitives.ZonedDateTime]
    def costCategoryArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Arn] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("costCategoryArn", costCategoryArnValue)
    def effectiveStart: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ZonedDateTime] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("effectiveStart", effectiveStartValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.UpdateCostCategoryDefinitionResponse) extends UpdateCostCategoryDefinitionResponse.ReadOnly {
    override def costCategoryArnValue: scala.Option[primitives.Arn] = scala.Option(impl.costCategoryArn()).map(value => value: primitives.Arn)
    override def effectiveStartValue: scala.Option[primitives.ZonedDateTime] = scala.Option(impl.effectiveStart()).map(value => value: primitives.ZonedDateTime)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.UpdateCostCategoryDefinitionResponse): ReadOnly = new Wrapper(impl)
}