package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class UpdateAnomalyMonitorRequest(monitorArn: primitives.GenericString, monitorName: scala.Option[primitives.GenericString] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.UpdateAnomalyMonitorRequest = {
    import UpdateAnomalyMonitorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.UpdateAnomalyMonitorRequest.builder().monitorArn(monitorArn: java.lang.String).optionallyWith(monitorName.map(value => value: java.lang.String))(_.monitorName).build()
  }
  def asReadOnly: UpdateAnomalyMonitorRequest.ReadOnly = UpdateAnomalyMonitorRequest.wrap(buildAwsValue())
}
object UpdateAnomalyMonitorRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.UpdateAnomalyMonitorRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: UpdateAnomalyMonitorRequest = UpdateAnomalyMonitorRequest(monitorArnValue, monitorNameValue.map(value => value))
    def monitorArnValue: primitives.GenericString
    def monitorNameValue: scala.Option[primitives.GenericString]
    def monitorArn: ZIO[Any, Nothing, primitives.GenericString] = ZIO.succeed(monitorArnValue)
    def monitorName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("monitorName", monitorNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.UpdateAnomalyMonitorRequest) extends UpdateAnomalyMonitorRequest.ReadOnly {
    override def monitorArnValue: primitives.GenericString = impl.monitorArn(): primitives.GenericString
    override def monitorNameValue: scala.Option[primitives.GenericString] = scala.Option(impl.monitorName()).map(value => value: primitives.GenericString)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.UpdateAnomalyMonitorRequest): ReadOnly = new Wrapper(impl)
}