package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class TagValues(key: scala.Option[primitives.TagKey] = None, values: scala.Option[Iterable[primitives.Value]] = None, matchOptions: scala.Option[Iterable[MatchOption]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.TagValues = {
    import TagValues.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.TagValues.builder().optionallyWith(key.map(value => value: java.lang.String))(_.key).optionallyWith(values.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.values).optionallyWith(matchOptions.map(value => value.map { item => 
      item.unwrap.toString
    }.asJavaCollection))(_.matchOptionsWithStrings).build()
  }
  def asReadOnly: TagValues.ReadOnly = TagValues.wrap(buildAwsValue())
}
object TagValues {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.TagValues] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: TagValues = TagValues(keyValue.map(value => value), valuesValue.map(value => value), matchOptionsValue.map(value => value))
    def keyValue: scala.Option[primitives.TagKey]
    def valuesValue: scala.Option[List[primitives.Value]]
    def matchOptionsValue: scala.Option[List[MatchOption]]
    def key: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TagKey] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("key", keyValue)
    def values: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.Value]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("values", valuesValue)
    def matchOptions: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[MatchOption]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("matchOptions", matchOptionsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.TagValues) extends TagValues.ReadOnly {
    override def keyValue: scala.Option[primitives.TagKey] = scala.Option(impl.key()).map(value => value: primitives.TagKey)
    override def valuesValue: scala.Option[List[primitives.Value]] = scala.Option(impl.values()).map(value => value.asScala.map { item => 
      item: primitives.Value
    }.toList)
    override def matchOptionsValue: scala.Option[List[MatchOption]] = scala.Option(impl.matchOptions()).map(value => value.asScala.map { item => 
      MatchOption.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.TagValues): ReadOnly = new Wrapper(impl)
}