package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ServiceSpecification(ec2Specification: scala.Option[EC2Specification] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.ServiceSpecification = {
    import ServiceSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.ServiceSpecification.builder().optionallyWith(ec2Specification.map(value => value.buildAwsValue()))(_.ec2Specification).build()
  }
  def asReadOnly: ServiceSpecification.ReadOnly = ServiceSpecification.wrap(buildAwsValue())
}
object ServiceSpecification {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.ServiceSpecification] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ServiceSpecification = ServiceSpecification(ec2SpecificationValue.map(value => value.editable))
    def ec2SpecificationValue: scala.Option[EC2Specification.ReadOnly]
    def ec2Specification: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, EC2Specification.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ec2Specification", ec2SpecificationValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.ServiceSpecification) extends ServiceSpecification.ReadOnly { override def ec2SpecificationValue: scala.Option[EC2Specification.ReadOnly] = scala.Option(impl.ec2Specification()).map(value => EC2Specification.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.ServiceSpecification): ReadOnly = new Wrapper(impl)
}