package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class SavingsPlansPurchaseRecommendation(accountScope: scala.Option[AccountScope] = None, savingsPlansType: scala.Option[SupportedSavingsPlansType] = None, termInYears: scala.Option[TermInYears] = None, paymentOption: scala.Option[PaymentOption] = None, lookbackPeriodInDays: scala.Option[LookbackPeriodInDays] = None, savingsPlansPurchaseRecommendationDetails: scala.Option[Iterable[SavingsPlansPurchaseRecommendationDetail]] = None, savingsPlansPurchaseRecommendationSummary: scala.Option[SavingsPlansPurchaseRecommendationSummary] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.SavingsPlansPurchaseRecommendation = {
    import SavingsPlansPurchaseRecommendation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.SavingsPlansPurchaseRecommendation.builder().optionallyWith(accountScope.map(value => value.unwrap))(_.accountScope).optionallyWith(savingsPlansType.map(value => value.unwrap))(_.savingsPlansType).optionallyWith(termInYears.map(value => value.unwrap))(_.termInYears).optionallyWith(paymentOption.map(value => value.unwrap))(_.paymentOption).optionallyWith(lookbackPeriodInDays.map(value => value.unwrap))(_.lookbackPeriodInDays).optionallyWith(savingsPlansPurchaseRecommendationDetails.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.savingsPlansPurchaseRecommendationDetails).optionallyWith(savingsPlansPurchaseRecommendationSummary.map(value => value.buildAwsValue()))(_.savingsPlansPurchaseRecommendationSummary).build()
  }
  def asReadOnly: SavingsPlansPurchaseRecommendation.ReadOnly = SavingsPlansPurchaseRecommendation.wrap(buildAwsValue())
}
object SavingsPlansPurchaseRecommendation {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.SavingsPlansPurchaseRecommendation] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: SavingsPlansPurchaseRecommendation = SavingsPlansPurchaseRecommendation(accountScopeValue.map(value => value), savingsPlansTypeValue.map(value => value), termInYearsValue.map(value => value), paymentOptionValue.map(value => value), lookbackPeriodInDaysValue.map(value => value), savingsPlansPurchaseRecommendationDetailsValue.map(value => value.map { item => 
      item.editable
    }), savingsPlansPurchaseRecommendationSummaryValue.map(value => value.editable))
    def accountScopeValue: scala.Option[AccountScope]
    def savingsPlansTypeValue: scala.Option[SupportedSavingsPlansType]
    def termInYearsValue: scala.Option[TermInYears]
    def paymentOptionValue: scala.Option[PaymentOption]
    def lookbackPeriodInDaysValue: scala.Option[LookbackPeriodInDays]
    def savingsPlansPurchaseRecommendationDetailsValue: scala.Option[List[SavingsPlansPurchaseRecommendationDetail.ReadOnly]]
    def savingsPlansPurchaseRecommendationSummaryValue: scala.Option[SavingsPlansPurchaseRecommendationSummary.ReadOnly]
    def accountScope: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, AccountScope] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("accountScope", accountScopeValue)
    def savingsPlansType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, SupportedSavingsPlansType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("savingsPlansType", savingsPlansTypeValue)
    def termInYears: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, TermInYears] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("termInYears", termInYearsValue)
    def paymentOption: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, PaymentOption] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("paymentOption", paymentOptionValue)
    def lookbackPeriodInDays: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, LookbackPeriodInDays] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lookbackPeriodInDays", lookbackPeriodInDaysValue)
    def savingsPlansPurchaseRecommendationDetails: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[SavingsPlansPurchaseRecommendationDetail.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("savingsPlansPurchaseRecommendationDetails", savingsPlansPurchaseRecommendationDetailsValue)
    def savingsPlansPurchaseRecommendationSummary: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, SavingsPlansPurchaseRecommendationSummary.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("savingsPlansPurchaseRecommendationSummary", savingsPlansPurchaseRecommendationSummaryValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansPurchaseRecommendation) extends SavingsPlansPurchaseRecommendation.ReadOnly {
    override def accountScopeValue: scala.Option[AccountScope] = scala.Option(impl.accountScope()).map(value => AccountScope.wrap(value))
    override def savingsPlansTypeValue: scala.Option[SupportedSavingsPlansType] = scala.Option(impl.savingsPlansType()).map(value => SupportedSavingsPlansType.wrap(value))
    override def termInYearsValue: scala.Option[TermInYears] = scala.Option(impl.termInYears()).map(value => TermInYears.wrap(value))
    override def paymentOptionValue: scala.Option[PaymentOption] = scala.Option(impl.paymentOption()).map(value => PaymentOption.wrap(value))
    override def lookbackPeriodInDaysValue: scala.Option[LookbackPeriodInDays] = scala.Option(impl.lookbackPeriodInDays()).map(value => LookbackPeriodInDays.wrap(value))
    override def savingsPlansPurchaseRecommendationDetailsValue: scala.Option[List[SavingsPlansPurchaseRecommendationDetail.ReadOnly]] = scala.Option(impl.savingsPlansPurchaseRecommendationDetails()).map(value => value.asScala.map { item => 
      SavingsPlansPurchaseRecommendationDetail.wrap(item)
    }.toList)
    override def savingsPlansPurchaseRecommendationSummaryValue: scala.Option[SavingsPlansPurchaseRecommendationSummary.ReadOnly] = scala.Option(impl.savingsPlansPurchaseRecommendationSummary()).map(value => SavingsPlansPurchaseRecommendationSummary.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansPurchaseRecommendation): ReadOnly = new Wrapper(impl)
}