package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait RightsizingType { def unwrap: software.amazon.awssdk.services.costexplorer.model.RightsizingType }
object RightsizingType {
  def wrap(value: software.amazon.awssdk.services.costexplorer.model.RightsizingType): RightsizingType = value match {
    case software.amazon.awssdk.services.costexplorer.model.RightsizingType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.costexplorer.model.RightsizingType.TERMINATE =>
      val r = TERMINATE
      r
    case software.amazon.awssdk.services.costexplorer.model.RightsizingType.MODIFY =>
      val r = MODIFY
      r
  }
  case object unknownToSdkVersion extends RightsizingType { override def unwrap: software.amazon.awssdk.services.costexplorer.model.RightsizingType = software.amazon.awssdk.services.costexplorer.model.RightsizingType.UNKNOWN_TO_SDK_VERSION }
  case object TERMINATE extends RightsizingType { override def unwrap: software.amazon.awssdk.services.costexplorer.model.RightsizingType = software.amazon.awssdk.services.costexplorer.model.RightsizingType.TERMINATE }
  case object MODIFY extends RightsizingType { override def unwrap: software.amazon.awssdk.services.costexplorer.model.RightsizingType = software.amazon.awssdk.services.costexplorer.model.RightsizingType.MODIFY }
}