package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class RightsizingRecommendationMetadata(recommendationId: scala.Option[primitives.GenericString] = None, generationTimestamp: scala.Option[primitives.GenericString] = None, lookbackPeriodInDays: scala.Option[LookbackPeriodInDays] = None, additionalMetadata: scala.Option[primitives.GenericString] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendationMetadata = {
    import RightsizingRecommendationMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendationMetadata.builder().optionallyWith(recommendationId.map(value => value: java.lang.String))(_.recommendationId).optionallyWith(generationTimestamp.map(value => value: java.lang.String))(_.generationTimestamp).optionallyWith(lookbackPeriodInDays.map(value => value.unwrap))(_.lookbackPeriodInDays).optionallyWith(additionalMetadata.map(value => value: java.lang.String))(_.additionalMetadata).build()
  }
  def asReadOnly: RightsizingRecommendationMetadata.ReadOnly = RightsizingRecommendationMetadata.wrap(buildAwsValue())
}
object RightsizingRecommendationMetadata {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendationMetadata] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: RightsizingRecommendationMetadata = RightsizingRecommendationMetadata(recommendationIdValue.map(value => value), generationTimestampValue.map(value => value), lookbackPeriodInDaysValue.map(value => value), additionalMetadataValue.map(value => value))
    def recommendationIdValue: scala.Option[primitives.GenericString]
    def generationTimestampValue: scala.Option[primitives.GenericString]
    def lookbackPeriodInDaysValue: scala.Option[LookbackPeriodInDays]
    def additionalMetadataValue: scala.Option[primitives.GenericString]
    def recommendationId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("recommendationId", recommendationIdValue)
    def generationTimestamp: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("generationTimestamp", generationTimestampValue)
    def lookbackPeriodInDays: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, LookbackPeriodInDays] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lookbackPeriodInDays", lookbackPeriodInDaysValue)
    def additionalMetadata: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("additionalMetadata", additionalMetadataValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendationMetadata) extends RightsizingRecommendationMetadata.ReadOnly {
    override def recommendationIdValue: scala.Option[primitives.GenericString] = scala.Option(impl.recommendationId()).map(value => value: primitives.GenericString)
    override def generationTimestampValue: scala.Option[primitives.GenericString] = scala.Option(impl.generationTimestamp()).map(value => value: primitives.GenericString)
    override def lookbackPeriodInDaysValue: scala.Option[LookbackPeriodInDays] = scala.Option(impl.lookbackPeriodInDays()).map(value => LookbackPeriodInDays.wrap(value))
    override def additionalMetadataValue: scala.Option[primitives.GenericString] = scala.Option(impl.additionalMetadata()).map(value => value: primitives.GenericString)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendationMetadata): ReadOnly = new Wrapper(impl)
}