package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ReservationPurchaseRecommendation(accountScope: scala.Option[AccountScope] = None, lookbackPeriodInDays: scala.Option[LookbackPeriodInDays] = None, termInYears: scala.Option[TermInYears] = None, paymentOption: scala.Option[PaymentOption] = None, serviceSpecification: scala.Option[ServiceSpecification] = None, recommendationDetails: scala.Option[Iterable[ReservationPurchaseRecommendationDetail]] = None, recommendationSummary: scala.Option[ReservationPurchaseRecommendationSummary] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendation = {
    import ReservationPurchaseRecommendation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendation.builder().optionallyWith(accountScope.map(value => value.unwrap))(_.accountScope).optionallyWith(lookbackPeriodInDays.map(value => value.unwrap))(_.lookbackPeriodInDays).optionallyWith(termInYears.map(value => value.unwrap))(_.termInYears).optionallyWith(paymentOption.map(value => value.unwrap))(_.paymentOption).optionallyWith(serviceSpecification.map(value => value.buildAwsValue()))(_.serviceSpecification).optionallyWith(recommendationDetails.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.recommendationDetails).optionallyWith(recommendationSummary.map(value => value.buildAwsValue()))(_.recommendationSummary).build()
  }
  def asReadOnly: ReservationPurchaseRecommendation.ReadOnly = ReservationPurchaseRecommendation.wrap(buildAwsValue())
}
object ReservationPurchaseRecommendation {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendation] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ReservationPurchaseRecommendation = ReservationPurchaseRecommendation(accountScopeValue.map(value => value), lookbackPeriodInDaysValue.map(value => value), termInYearsValue.map(value => value), paymentOptionValue.map(value => value), serviceSpecificationValue.map(value => value.editable), recommendationDetailsValue.map(value => value.map { item => 
      item.editable
    }), recommendationSummaryValue.map(value => value.editable))
    def accountScopeValue: scala.Option[AccountScope]
    def lookbackPeriodInDaysValue: scala.Option[LookbackPeriodInDays]
    def termInYearsValue: scala.Option[TermInYears]
    def paymentOptionValue: scala.Option[PaymentOption]
    def serviceSpecificationValue: scala.Option[ServiceSpecification.ReadOnly]
    def recommendationDetailsValue: scala.Option[List[ReservationPurchaseRecommendationDetail.ReadOnly]]
    def recommendationSummaryValue: scala.Option[ReservationPurchaseRecommendationSummary.ReadOnly]
    def accountScope: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, AccountScope] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("accountScope", accountScopeValue)
    def lookbackPeriodInDays: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, LookbackPeriodInDays] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lookbackPeriodInDays", lookbackPeriodInDaysValue)
    def termInYears: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, TermInYears] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("termInYears", termInYearsValue)
    def paymentOption: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, PaymentOption] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("paymentOption", paymentOptionValue)
    def serviceSpecification: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ServiceSpecification.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("serviceSpecification", serviceSpecificationValue)
    def recommendationDetails: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[ReservationPurchaseRecommendationDetail.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("recommendationDetails", recommendationDetailsValue)
    def recommendationSummary: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ReservationPurchaseRecommendationSummary.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("recommendationSummary", recommendationSummaryValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendation) extends ReservationPurchaseRecommendation.ReadOnly {
    override def accountScopeValue: scala.Option[AccountScope] = scala.Option(impl.accountScope()).map(value => AccountScope.wrap(value))
    override def lookbackPeriodInDaysValue: scala.Option[LookbackPeriodInDays] = scala.Option(impl.lookbackPeriodInDays()).map(value => LookbackPeriodInDays.wrap(value))
    override def termInYearsValue: scala.Option[TermInYears] = scala.Option(impl.termInYears()).map(value => TermInYears.wrap(value))
    override def paymentOptionValue: scala.Option[PaymentOption] = scala.Option(impl.paymentOption()).map(value => PaymentOption.wrap(value))
    override def serviceSpecificationValue: scala.Option[ServiceSpecification.ReadOnly] = scala.Option(impl.serviceSpecification()).map(value => ServiceSpecification.wrap(value))
    override def recommendationDetailsValue: scala.Option[List[ReservationPurchaseRecommendationDetail.ReadOnly]] = scala.Option(impl.recommendationDetails()).map(value => value.asScala.map { item => 
      ReservationPurchaseRecommendationDetail.wrap(item)
    }.toList)
    override def recommendationSummaryValue: scala.Option[ReservationPurchaseRecommendationSummary.ReadOnly] = scala.Option(impl.recommendationSummary()).map(value => ReservationPurchaseRecommendationSummary.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendation): ReadOnly = new Wrapper(impl)
}