package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ReservationAggregates(utilizationPercentage: scala.Option[primitives.UtilizationPercentage] = None, utilizationPercentageInUnits: scala.Option[primitives.UtilizationPercentageInUnits] = None, purchasedHours: scala.Option[primitives.PurchasedHours] = None, purchasedUnits: scala.Option[primitives.PurchasedUnits] = None, totalActualHours: scala.Option[primitives.TotalActualHours] = None, totalActualUnits: scala.Option[primitives.TotalActualUnits] = None, unusedHours: scala.Option[primitives.UnusedHours] = None, unusedUnits: scala.Option[primitives.UnusedUnits] = None, onDemandCostOfRIHoursUsed: scala.Option[primitives.OnDemandCostOfRIHoursUsed] = None, netRISavings: scala.Option[primitives.NetRISavings] = None, totalPotentialRISavings: scala.Option[primitives.TotalPotentialRISavings] = None, amortizedUpfrontFee: scala.Option[primitives.AmortizedUpfrontFee] = None, amortizedRecurringFee: scala.Option[primitives.AmortizedRecurringFee] = None, totalAmortizedFee: scala.Option[primitives.TotalAmortizedFee] = None, riCostForUnusedHours: scala.Option[primitives.RICostForUnusedHours] = None, realizedSavings: scala.Option[primitives.RealizedSavings] = None, unrealizedSavings: scala.Option[primitives.UnrealizedSavings] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.ReservationAggregates = {
    import ReservationAggregates.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.ReservationAggregates.builder().optionallyWith(utilizationPercentage.map(value => value: java.lang.String))(_.utilizationPercentage).optionallyWith(utilizationPercentageInUnits.map(value => value: java.lang.String))(_.utilizationPercentageInUnits).optionallyWith(purchasedHours.map(value => value: java.lang.String))(_.purchasedHours).optionallyWith(purchasedUnits.map(value => value: java.lang.String))(_.purchasedUnits).optionallyWith(totalActualHours.map(value => value: java.lang.String))(_.totalActualHours).optionallyWith(totalActualUnits.map(value => value: java.lang.String))(_.totalActualUnits).optionallyWith(unusedHours.map(value => value: java.lang.String))(_.unusedHours).optionallyWith(unusedUnits.map(value => value: java.lang.String))(_.unusedUnits).optionallyWith(onDemandCostOfRIHoursUsed.map(value => value: java.lang.String))(_.onDemandCostOfRIHoursUsed).optionallyWith(netRISavings.map(value => value: java.lang.String))(_.netRISavings).optionallyWith(totalPotentialRISavings.map(value => value: java.lang.String))(_.totalPotentialRISavings).optionallyWith(amortizedUpfrontFee.map(value => value: java.lang.String))(_.amortizedUpfrontFee).optionallyWith(amortizedRecurringFee.map(value => value: java.lang.String))(_.amortizedRecurringFee).optionallyWith(totalAmortizedFee.map(value => value: java.lang.String))(_.totalAmortizedFee).optionallyWith(riCostForUnusedHours.map(value => value: java.lang.String))(_.riCostForUnusedHours).optionallyWith(realizedSavings.map(value => value: java.lang.String))(_.realizedSavings).optionallyWith(unrealizedSavings.map(value => value: java.lang.String))(_.unrealizedSavings).build()
  }
  def asReadOnly: ReservationAggregates.ReadOnly = ReservationAggregates.wrap(buildAwsValue())
}
object ReservationAggregates {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.ReservationAggregates] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ReservationAggregates = ReservationAggregates(utilizationPercentageValue.map(value => value), utilizationPercentageInUnitsValue.map(value => value), purchasedHoursValue.map(value => value), purchasedUnitsValue.map(value => value), totalActualHoursValue.map(value => value), totalActualUnitsValue.map(value => value), unusedHoursValue.map(value => value), unusedUnitsValue.map(value => value), onDemandCostOfRIHoursUsedValue.map(value => value), netRISavingsValue.map(value => value), totalPotentialRISavingsValue.map(value => value), amortizedUpfrontFeeValue.map(value => value), amortizedRecurringFeeValue.map(value => value), totalAmortizedFeeValue.map(value => value), riCostForUnusedHoursValue.map(value => value), realizedSavingsValue.map(value => value), unrealizedSavingsValue.map(value => value))
    def utilizationPercentageValue: scala.Option[primitives.UtilizationPercentage]
    def utilizationPercentageInUnitsValue: scala.Option[primitives.UtilizationPercentageInUnits]
    def purchasedHoursValue: scala.Option[primitives.PurchasedHours]
    def purchasedUnitsValue: scala.Option[primitives.PurchasedUnits]
    def totalActualHoursValue: scala.Option[primitives.TotalActualHours]
    def totalActualUnitsValue: scala.Option[primitives.TotalActualUnits]
    def unusedHoursValue: scala.Option[primitives.UnusedHours]
    def unusedUnitsValue: scala.Option[primitives.UnusedUnits]
    def onDemandCostOfRIHoursUsedValue: scala.Option[primitives.OnDemandCostOfRIHoursUsed]
    def netRISavingsValue: scala.Option[primitives.NetRISavings]
    def totalPotentialRISavingsValue: scala.Option[primitives.TotalPotentialRISavings]
    def amortizedUpfrontFeeValue: scala.Option[primitives.AmortizedUpfrontFee]
    def amortizedRecurringFeeValue: scala.Option[primitives.AmortizedRecurringFee]
    def totalAmortizedFeeValue: scala.Option[primitives.TotalAmortizedFee]
    def riCostForUnusedHoursValue: scala.Option[primitives.RICostForUnusedHours]
    def realizedSavingsValue: scala.Option[primitives.RealizedSavings]
    def unrealizedSavingsValue: scala.Option[primitives.UnrealizedSavings]
    def utilizationPercentage: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.UtilizationPercentage] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("utilizationPercentage", utilizationPercentageValue)
    def utilizationPercentageInUnits: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.UtilizationPercentageInUnits] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("utilizationPercentageInUnits", utilizationPercentageInUnitsValue)
    def purchasedHours: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PurchasedHours] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("purchasedHours", purchasedHoursValue)
    def purchasedUnits: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PurchasedUnits] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("purchasedUnits", purchasedUnitsValue)
    def totalActualHours: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TotalActualHours] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("totalActualHours", totalActualHoursValue)
    def totalActualUnits: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TotalActualUnits] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("totalActualUnits", totalActualUnitsValue)
    def unusedHours: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.UnusedHours] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("unusedHours", unusedHoursValue)
    def unusedUnits: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.UnusedUnits] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("unusedUnits", unusedUnitsValue)
    def onDemandCostOfRIHoursUsed: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.OnDemandCostOfRIHoursUsed] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("onDemandCostOfRIHoursUsed", onDemandCostOfRIHoursUsedValue)
    def netRISavings: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NetRISavings] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("netRISavings", netRISavingsValue)
    def totalPotentialRISavings: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TotalPotentialRISavings] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("totalPotentialRISavings", totalPotentialRISavingsValue)
    def amortizedUpfrontFee: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AmortizedUpfrontFee] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("amortizedUpfrontFee", amortizedUpfrontFeeValue)
    def amortizedRecurringFee: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AmortizedRecurringFee] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("amortizedRecurringFee", amortizedRecurringFeeValue)
    def totalAmortizedFee: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TotalAmortizedFee] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("totalAmortizedFee", totalAmortizedFeeValue)
    def riCostForUnusedHours: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.RICostForUnusedHours] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("riCostForUnusedHours", riCostForUnusedHoursValue)
    def realizedSavings: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.RealizedSavings] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("realizedSavings", realizedSavingsValue)
    def unrealizedSavings: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.UnrealizedSavings] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("unrealizedSavings", unrealizedSavingsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.ReservationAggregates) extends ReservationAggregates.ReadOnly {
    override def utilizationPercentageValue: scala.Option[primitives.UtilizationPercentage] = scala.Option(impl.utilizationPercentage()).map(value => value: primitives.UtilizationPercentage)
    override def utilizationPercentageInUnitsValue: scala.Option[primitives.UtilizationPercentageInUnits] = scala.Option(impl.utilizationPercentageInUnits()).map(value => value: primitives.UtilizationPercentageInUnits)
    override def purchasedHoursValue: scala.Option[primitives.PurchasedHours] = scala.Option(impl.purchasedHours()).map(value => value: primitives.PurchasedHours)
    override def purchasedUnitsValue: scala.Option[primitives.PurchasedUnits] = scala.Option(impl.purchasedUnits()).map(value => value: primitives.PurchasedUnits)
    override def totalActualHoursValue: scala.Option[primitives.TotalActualHours] = scala.Option(impl.totalActualHours()).map(value => value: primitives.TotalActualHours)
    override def totalActualUnitsValue: scala.Option[primitives.TotalActualUnits] = scala.Option(impl.totalActualUnits()).map(value => value: primitives.TotalActualUnits)
    override def unusedHoursValue: scala.Option[primitives.UnusedHours] = scala.Option(impl.unusedHours()).map(value => value: primitives.UnusedHours)
    override def unusedUnitsValue: scala.Option[primitives.UnusedUnits] = scala.Option(impl.unusedUnits()).map(value => value: primitives.UnusedUnits)
    override def onDemandCostOfRIHoursUsedValue: scala.Option[primitives.OnDemandCostOfRIHoursUsed] = scala.Option(impl.onDemandCostOfRIHoursUsed()).map(value => value: primitives.OnDemandCostOfRIHoursUsed)
    override def netRISavingsValue: scala.Option[primitives.NetRISavings] = scala.Option(impl.netRISavings()).map(value => value: primitives.NetRISavings)
    override def totalPotentialRISavingsValue: scala.Option[primitives.TotalPotentialRISavings] = scala.Option(impl.totalPotentialRISavings()).map(value => value: primitives.TotalPotentialRISavings)
    override def amortizedUpfrontFeeValue: scala.Option[primitives.AmortizedUpfrontFee] = scala.Option(impl.amortizedUpfrontFee()).map(value => value: primitives.AmortizedUpfrontFee)
    override def amortizedRecurringFeeValue: scala.Option[primitives.AmortizedRecurringFee] = scala.Option(impl.amortizedRecurringFee()).map(value => value: primitives.AmortizedRecurringFee)
    override def totalAmortizedFeeValue: scala.Option[primitives.TotalAmortizedFee] = scala.Option(impl.totalAmortizedFee()).map(value => value: primitives.TotalAmortizedFee)
    override def riCostForUnusedHoursValue: scala.Option[primitives.RICostForUnusedHours] = scala.Option(impl.riCostForUnusedHours()).map(value => value: primitives.RICostForUnusedHours)
    override def realizedSavingsValue: scala.Option[primitives.RealizedSavings] = scala.Option(impl.realizedSavings()).map(value => value: primitives.RealizedSavings)
    override def unrealizedSavingsValue: scala.Option[primitives.UnrealizedSavings] = scala.Option(impl.unrealizedSavings()).map(value => value: primitives.UnrealizedSavings)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.ReservationAggregates): ReadOnly = new Wrapper(impl)
}