package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class RedshiftInstanceDetails(family: scala.Option[primitives.GenericString] = None, nodeType: scala.Option[primitives.GenericString] = None, region: scala.Option[primitives.GenericString] = None, currentGeneration: scala.Option[primitives.GenericBoolean] = None, sizeFlexEligible: scala.Option[primitives.GenericBoolean] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.RedshiftInstanceDetails = {
    import RedshiftInstanceDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.RedshiftInstanceDetails.builder().optionallyWith(family.map(value => value: java.lang.String))(_.family).optionallyWith(nodeType.map(value => value: java.lang.String))(_.nodeType).optionallyWith(region.map(value => value: java.lang.String))(_.region).optionallyWith(currentGeneration.map(value => value: java.lang.Boolean))(_.currentGeneration).optionallyWith(sizeFlexEligible.map(value => value: java.lang.Boolean))(_.sizeFlexEligible).build()
  }
  def asReadOnly: RedshiftInstanceDetails.ReadOnly = RedshiftInstanceDetails.wrap(buildAwsValue())
}
object RedshiftInstanceDetails {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.RedshiftInstanceDetails] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: RedshiftInstanceDetails = RedshiftInstanceDetails(familyValue.map(value => value), nodeTypeValue.map(value => value), regionValue.map(value => value), currentGenerationValue.map(value => value), sizeFlexEligibleValue.map(value => value))
    def familyValue: scala.Option[primitives.GenericString]
    def nodeTypeValue: scala.Option[primitives.GenericString]
    def regionValue: scala.Option[primitives.GenericString]
    def currentGenerationValue: scala.Option[primitives.GenericBoolean]
    def sizeFlexEligibleValue: scala.Option[primitives.GenericBoolean]
    def family: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("family", familyValue)
    def nodeType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nodeType", nodeTypeValue)
    def region: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("region", regionValue)
    def currentGeneration: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericBoolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("currentGeneration", currentGenerationValue)
    def sizeFlexEligible: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericBoolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sizeFlexEligible", sizeFlexEligibleValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.RedshiftInstanceDetails) extends RedshiftInstanceDetails.ReadOnly {
    override def familyValue: scala.Option[primitives.GenericString] = scala.Option(impl.family()).map(value => value: primitives.GenericString)
    override def nodeTypeValue: scala.Option[primitives.GenericString] = scala.Option(impl.nodeType()).map(value => value: primitives.GenericString)
    override def regionValue: scala.Option[primitives.GenericString] = scala.Option(impl.region()).map(value => value: primitives.GenericString)
    override def currentGenerationValue: scala.Option[primitives.GenericBoolean] = scala.Option(impl.currentGeneration()).map(value => value: primitives.GenericBoolean)
    override def sizeFlexEligibleValue: scala.Option[primitives.GenericBoolean] = scala.Option(impl.sizeFlexEligible()).map(value => value: primitives.GenericBoolean)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.RedshiftInstanceDetails): ReadOnly = new Wrapper(impl)
}