package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait PaymentOption { def unwrap: software.amazon.awssdk.services.costexplorer.model.PaymentOption }
object PaymentOption {
  def wrap(value: software.amazon.awssdk.services.costexplorer.model.PaymentOption): PaymentOption = value match {
    case software.amazon.awssdk.services.costexplorer.model.PaymentOption.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.costexplorer.model.PaymentOption.NO_UPFRONT =>
      val r = NO_UPFRONT
      r
    case software.amazon.awssdk.services.costexplorer.model.PaymentOption.PARTIAL_UPFRONT =>
      val r = PARTIAL_UPFRONT
      r
    case software.amazon.awssdk.services.costexplorer.model.PaymentOption.ALL_UPFRONT =>
      val r = ALL_UPFRONT
      r
    case software.amazon.awssdk.services.costexplorer.model.PaymentOption.LIGHT_UTILIZATION =>
      val r = LIGHT_UTILIZATION
      r
    case software.amazon.awssdk.services.costexplorer.model.PaymentOption.MEDIUM_UTILIZATION =>
      val r = MEDIUM_UTILIZATION
      r
    case software.amazon.awssdk.services.costexplorer.model.PaymentOption.HEAVY_UTILIZATION =>
      val r = HEAVY_UTILIZATION
      r
  }
  case object unknownToSdkVersion extends PaymentOption { override def unwrap: software.amazon.awssdk.services.costexplorer.model.PaymentOption = software.amazon.awssdk.services.costexplorer.model.PaymentOption.UNKNOWN_TO_SDK_VERSION }
  case object NO_UPFRONT extends PaymentOption { override def unwrap: software.amazon.awssdk.services.costexplorer.model.PaymentOption = software.amazon.awssdk.services.costexplorer.model.PaymentOption.NO_UPFRONT }
  case object PARTIAL_UPFRONT extends PaymentOption { override def unwrap: software.amazon.awssdk.services.costexplorer.model.PaymentOption = software.amazon.awssdk.services.costexplorer.model.PaymentOption.PARTIAL_UPFRONT }
  case object ALL_UPFRONT extends PaymentOption { override def unwrap: software.amazon.awssdk.services.costexplorer.model.PaymentOption = software.amazon.awssdk.services.costexplorer.model.PaymentOption.ALL_UPFRONT }
  case object LIGHT_UTILIZATION extends PaymentOption { override def unwrap: software.amazon.awssdk.services.costexplorer.model.PaymentOption = software.amazon.awssdk.services.costexplorer.model.PaymentOption.LIGHT_UTILIZATION }
  case object MEDIUM_UTILIZATION extends PaymentOption { override def unwrap: software.amazon.awssdk.services.costexplorer.model.PaymentOption = software.amazon.awssdk.services.costexplorer.model.PaymentOption.MEDIUM_UTILIZATION }
  case object HEAVY_UTILIZATION extends PaymentOption { override def unwrap: software.amazon.awssdk.services.costexplorer.model.PaymentOption = software.amazon.awssdk.services.costexplorer.model.PaymentOption.HEAVY_UTILIZATION }
}