package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait NumericOperator { def unwrap: software.amazon.awssdk.services.costexplorer.model.NumericOperator }
object NumericOperator {
  def wrap(value: software.amazon.awssdk.services.costexplorer.model.NumericOperator): NumericOperator = value match {
    case software.amazon.awssdk.services.costexplorer.model.NumericOperator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.costexplorer.model.NumericOperator.EQUAL =>
      val r = EQUAL
      r
    case software.amazon.awssdk.services.costexplorer.model.NumericOperator.GREATER_THAN_OR_EQUAL =>
      val r = GREATER_THAN_OR_EQUAL
      r
    case software.amazon.awssdk.services.costexplorer.model.NumericOperator.LESS_THAN_OR_EQUAL =>
      val r = LESS_THAN_OR_EQUAL
      r
    case software.amazon.awssdk.services.costexplorer.model.NumericOperator.GREATER_THAN =>
      val r = GREATER_THAN
      r
    case software.amazon.awssdk.services.costexplorer.model.NumericOperator.LESS_THAN =>
      val r = LESS_THAN
      r
    case software.amazon.awssdk.services.costexplorer.model.NumericOperator.BETWEEN =>
      val r = BETWEEN
      r
  }
  case object unknownToSdkVersion extends NumericOperator { override def unwrap: software.amazon.awssdk.services.costexplorer.model.NumericOperator = software.amazon.awssdk.services.costexplorer.model.NumericOperator.UNKNOWN_TO_SDK_VERSION }
  case object EQUAL extends NumericOperator { override def unwrap: software.amazon.awssdk.services.costexplorer.model.NumericOperator = software.amazon.awssdk.services.costexplorer.model.NumericOperator.EQUAL }
  case object GREATER_THAN_OR_EQUAL extends NumericOperator { override def unwrap: software.amazon.awssdk.services.costexplorer.model.NumericOperator = software.amazon.awssdk.services.costexplorer.model.NumericOperator.GREATER_THAN_OR_EQUAL }
  case object LESS_THAN_OR_EQUAL extends NumericOperator { override def unwrap: software.amazon.awssdk.services.costexplorer.model.NumericOperator = software.amazon.awssdk.services.costexplorer.model.NumericOperator.LESS_THAN_OR_EQUAL }
  case object GREATER_THAN extends NumericOperator { override def unwrap: software.amazon.awssdk.services.costexplorer.model.NumericOperator = software.amazon.awssdk.services.costexplorer.model.NumericOperator.GREATER_THAN }
  case object LESS_THAN extends NumericOperator { override def unwrap: software.amazon.awssdk.services.costexplorer.model.NumericOperator = software.amazon.awssdk.services.costexplorer.model.NumericOperator.LESS_THAN }
  case object BETWEEN extends NumericOperator { override def unwrap: software.amazon.awssdk.services.costexplorer.model.NumericOperator = software.amazon.awssdk.services.costexplorer.model.NumericOperator.BETWEEN }
}