package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListCostCategoryDefinitionsRequest(effectiveOn: scala.Option[primitives.ZonedDateTime] = None, nextToken: scala.Option[primitives.NextPageToken] = None, maxResults: scala.Option[primitives.CostCategoryMaxResults] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsRequest = {
    import ListCostCategoryDefinitionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsRequest.builder().optionallyWith(effectiveOn.map(value => value: java.lang.String))(_.effectiveOn).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).optionallyWith(maxResults.map(value => value: java.lang.Integer))(_.maxResults).build()
  }
  def asReadOnly: ListCostCategoryDefinitionsRequest.ReadOnly = ListCostCategoryDefinitionsRequest.wrap(buildAwsValue())
}
object ListCostCategoryDefinitionsRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListCostCategoryDefinitionsRequest = ListCostCategoryDefinitionsRequest(effectiveOnValue.map(value => value), nextTokenValue.map(value => value), maxResultsValue.map(value => value))
    def effectiveOnValue: scala.Option[primitives.ZonedDateTime]
    def nextTokenValue: scala.Option[primitives.NextPageToken]
    def maxResultsValue: scala.Option[primitives.CostCategoryMaxResults]
    def effectiveOn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ZonedDateTime] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("effectiveOn", effectiveOnValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextPageToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.CostCategoryMaxResults] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsRequest) extends ListCostCategoryDefinitionsRequest.ReadOnly {
    override def effectiveOnValue: scala.Option[primitives.ZonedDateTime] = scala.Option(impl.effectiveOn()).map(value => value: primitives.ZonedDateTime)
    override def nextTokenValue: scala.Option[primitives.NextPageToken] = scala.Option(impl.nextToken()).map(value => value: primitives.NextPageToken)
    override def maxResultsValue: scala.Option[primitives.CostCategoryMaxResults] = scala.Option(impl.maxResults()).map(value => value: primitives.CostCategoryMaxResults)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsRequest): ReadOnly = new Wrapper(impl)
}