package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait GroupDefinitionType { def unwrap: software.amazon.awssdk.services.costexplorer.model.GroupDefinitionType }
object GroupDefinitionType {
  def wrap(value: software.amazon.awssdk.services.costexplorer.model.GroupDefinitionType): GroupDefinitionType = value match {
    case software.amazon.awssdk.services.costexplorer.model.GroupDefinitionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.costexplorer.model.GroupDefinitionType.DIMENSION =>
      val r = DIMENSION
      r
    case software.amazon.awssdk.services.costexplorer.model.GroupDefinitionType.TAG =>
      val r = TAG
      r
    case software.amazon.awssdk.services.costexplorer.model.GroupDefinitionType.COST_CATEGORY =>
      val r = COST_CATEGORY
      r
  }
  case object unknownToSdkVersion extends GroupDefinitionType { override def unwrap: software.amazon.awssdk.services.costexplorer.model.GroupDefinitionType = software.amazon.awssdk.services.costexplorer.model.GroupDefinitionType.UNKNOWN_TO_SDK_VERSION }
  case object DIMENSION extends GroupDefinitionType { override def unwrap: software.amazon.awssdk.services.costexplorer.model.GroupDefinitionType = software.amazon.awssdk.services.costexplorer.model.GroupDefinitionType.DIMENSION }
  case object TAG extends GroupDefinitionType { override def unwrap: software.amazon.awssdk.services.costexplorer.model.GroupDefinitionType = software.amazon.awssdk.services.costexplorer.model.GroupDefinitionType.TAG }
  case object COST_CATEGORY extends GroupDefinitionType { override def unwrap: software.amazon.awssdk.services.costexplorer.model.GroupDefinitionType = software.amazon.awssdk.services.costexplorer.model.GroupDefinitionType.COST_CATEGORY }
}