package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetSavingsPlansUtilizationRequest(timePeriod: DateInterval, granularity: scala.Option[Granularity] = None, filter: scala.Option[Expression] = None, sortBy: scala.Option[SortDefinition] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationRequest = {
    import GetSavingsPlansUtilizationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationRequest.builder().timePeriod(timePeriod.buildAwsValue()).optionallyWith(granularity.map(value => value.unwrap))(_.granularity).optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter).optionallyWith(sortBy.map(value => value.buildAwsValue()))(_.sortBy).build()
  }
  def asReadOnly: GetSavingsPlansUtilizationRequest.ReadOnly = GetSavingsPlansUtilizationRequest.wrap(buildAwsValue())
}
object GetSavingsPlansUtilizationRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetSavingsPlansUtilizationRequest = GetSavingsPlansUtilizationRequest(timePeriodValue.editable, granularityValue.map(value => value), filterValue.map(value => value.editable), sortByValue.map(value => value.editable))
    def timePeriodValue: DateInterval.ReadOnly
    def granularityValue: scala.Option[Granularity]
    def filterValue: scala.Option[Expression.ReadOnly]
    def sortByValue: scala.Option[SortDefinition.ReadOnly]
    def timePeriod: ZIO[Any, Nothing, DateInterval.ReadOnly] = ZIO.succeed(timePeriodValue)
    def granularity: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Granularity] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("granularity", granularityValue)
    def filter: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Expression.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filter", filterValue)
    def sortBy: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, SortDefinition.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sortBy", sortByValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationRequest) extends GetSavingsPlansUtilizationRequest.ReadOnly {
    override def timePeriodValue: DateInterval.ReadOnly = DateInterval.wrap(impl.timePeriod())
    override def granularityValue: scala.Option[Granularity] = scala.Option(impl.granularity()).map(value => Granularity.wrap(value))
    override def filterValue: scala.Option[Expression.ReadOnly] = scala.Option(impl.filter()).map(value => Expression.wrap(value))
    override def sortByValue: scala.Option[SortDefinition.ReadOnly] = scala.Option(impl.sortBy()).map(value => SortDefinition.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationRequest): ReadOnly = new Wrapper(impl)
}