package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetSavingsPlansPurchaseRecommendationRequest(savingsPlansType: SupportedSavingsPlansType, termInYears: TermInYears, paymentOption: PaymentOption, accountScope: scala.Option[AccountScope] = None, nextPageToken: scala.Option[primitives.NextPageToken] = None, pageSize: scala.Option[primitives.NonNegativeInteger] = None, lookbackPeriodInDays: LookbackPeriodInDays, filter: scala.Option[Expression] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationRequest = {
    import GetSavingsPlansPurchaseRecommendationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationRequest.builder().savingsPlansType(savingsPlansType.unwrap).termInYears(termInYears.unwrap).paymentOption(paymentOption.unwrap).optionallyWith(accountScope.map(value => value.unwrap))(_.accountScope).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).optionallyWith(pageSize.map(value => value: java.lang.Integer))(_.pageSize).lookbackPeriodInDays(lookbackPeriodInDays.unwrap).optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter).build()
  }
  def asReadOnly: GetSavingsPlansPurchaseRecommendationRequest.ReadOnly = GetSavingsPlansPurchaseRecommendationRequest.wrap(buildAwsValue())
}
object GetSavingsPlansPurchaseRecommendationRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetSavingsPlansPurchaseRecommendationRequest = GetSavingsPlansPurchaseRecommendationRequest(savingsPlansTypeValue, termInYearsValue, paymentOptionValue, accountScopeValue.map(value => value), nextPageTokenValue.map(value => value), pageSizeValue.map(value => value), lookbackPeriodInDaysValue, filterValue.map(value => value.editable))
    def savingsPlansTypeValue: SupportedSavingsPlansType
    def termInYearsValue: TermInYears
    def paymentOptionValue: PaymentOption
    def accountScopeValue: scala.Option[AccountScope]
    def nextPageTokenValue: scala.Option[primitives.NextPageToken]
    def pageSizeValue: scala.Option[primitives.NonNegativeInteger]
    def lookbackPeriodInDaysValue: LookbackPeriodInDays
    def filterValue: scala.Option[Expression.ReadOnly]
    def savingsPlansType: ZIO[Any, Nothing, SupportedSavingsPlansType] = ZIO.succeed(savingsPlansTypeValue)
    def termInYears: ZIO[Any, Nothing, TermInYears] = ZIO.succeed(termInYearsValue)
    def paymentOption: ZIO[Any, Nothing, PaymentOption] = ZIO.succeed(paymentOptionValue)
    def accountScope: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, AccountScope] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("accountScope", accountScopeValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextPageToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
    def pageSize: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonNegativeInteger] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("pageSize", pageSizeValue)
    def lookbackPeriodInDays: ZIO[Any, Nothing, LookbackPeriodInDays] = ZIO.succeed(lookbackPeriodInDaysValue)
    def filter: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Expression.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filter", filterValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationRequest) extends GetSavingsPlansPurchaseRecommendationRequest.ReadOnly {
    override def savingsPlansTypeValue: SupportedSavingsPlansType = SupportedSavingsPlansType.wrap(impl.savingsPlansType())
    override def termInYearsValue: TermInYears = TermInYears.wrap(impl.termInYears())
    override def paymentOptionValue: PaymentOption = PaymentOption.wrap(impl.paymentOption())
    override def accountScopeValue: scala.Option[AccountScope] = scala.Option(impl.accountScope()).map(value => AccountScope.wrap(value))
    override def nextPageTokenValue: scala.Option[primitives.NextPageToken] = scala.Option(impl.nextPageToken()).map(value => value: primitives.NextPageToken)
    override def pageSizeValue: scala.Option[primitives.NonNegativeInteger] = scala.Option(impl.pageSize()).map(value => value: primitives.NonNegativeInteger)
    override def lookbackPeriodInDaysValue: LookbackPeriodInDays = LookbackPeriodInDays.wrap(impl.lookbackPeriodInDays())
    override def filterValue: scala.Option[Expression.ReadOnly] = scala.Option(impl.filter()).map(value => Expression.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationRequest): ReadOnly = new Wrapper(impl)
}