package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetReservationUtilizationResponse(utilizationsByTime: Iterable[UtilizationByTime], total: scala.Option[ReservationAggregates] = None, nextPageToken: scala.Option[primitives.NextPageToken] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.GetReservationUtilizationResponse = {
    import GetReservationUtilizationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetReservationUtilizationResponse.builder().utilizationsByTime(utilizationsByTime.map { item => 
      item.buildAwsValue()
    }.asJavaCollection).optionallyWith(total.map(value => value.buildAwsValue()))(_.total).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).build()
  }
  def asReadOnly: GetReservationUtilizationResponse.ReadOnly = GetReservationUtilizationResponse.wrap(buildAwsValue())
}
object GetReservationUtilizationResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.GetReservationUtilizationResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetReservationUtilizationResponse = GetReservationUtilizationResponse(utilizationsByTimeValue.map { item => 
      item.editable
    }, totalValue.map(value => value.editable), nextPageTokenValue.map(value => value))
    def utilizationsByTimeValue: List[UtilizationByTime.ReadOnly]
    def totalValue: scala.Option[ReservationAggregates.ReadOnly]
    def nextPageTokenValue: scala.Option[primitives.NextPageToken]
    def utilizationsByTime: ZIO[Any, Nothing, List[UtilizationByTime.ReadOnly]] = ZIO.succeed(utilizationsByTimeValue)
    def total: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ReservationAggregates.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("total", totalValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextPageToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.GetReservationUtilizationResponse) extends GetReservationUtilizationResponse.ReadOnly {
    override def utilizationsByTimeValue: List[UtilizationByTime.ReadOnly] = impl.utilizationsByTime().asScala.map { item => 
      UtilizationByTime.wrap(item)
    }.toList
    override def totalValue: scala.Option[ReservationAggregates.ReadOnly] = scala.Option(impl.total()).map(value => ReservationAggregates.wrap(value))
    override def nextPageTokenValue: scala.Option[primitives.NextPageToken] = scala.Option(impl.nextPageToken()).map(value => value: primitives.NextPageToken)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.GetReservationUtilizationResponse): ReadOnly = new Wrapper(impl)
}