package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetReservationPurchaseRecommendationResponse(metadata: scala.Option[ReservationPurchaseRecommendationMetadata] = None, recommendations: scala.Option[Iterable[ReservationPurchaseRecommendation]] = None, nextPageToken: scala.Option[primitives.NextPageToken] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.GetReservationPurchaseRecommendationResponse = {
    import GetReservationPurchaseRecommendationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetReservationPurchaseRecommendationResponse.builder().optionallyWith(metadata.map(value => value.buildAwsValue()))(_.metadata).optionallyWith(recommendations.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.recommendations).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).build()
  }
  def asReadOnly: GetReservationPurchaseRecommendationResponse.ReadOnly = GetReservationPurchaseRecommendationResponse.wrap(buildAwsValue())
}
object GetReservationPurchaseRecommendationResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.GetReservationPurchaseRecommendationResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetReservationPurchaseRecommendationResponse = GetReservationPurchaseRecommendationResponse(metadataValue.map(value => value.editable), recommendationsValue.map(value => value.map { item => 
      item.editable
    }), nextPageTokenValue.map(value => value))
    def metadataValue: scala.Option[ReservationPurchaseRecommendationMetadata.ReadOnly]
    def recommendationsValue: scala.Option[List[ReservationPurchaseRecommendation.ReadOnly]]
    def nextPageTokenValue: scala.Option[primitives.NextPageToken]
    def metadata: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ReservationPurchaseRecommendationMetadata.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("metadata", metadataValue)
    def recommendations: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[ReservationPurchaseRecommendation.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("recommendations", recommendationsValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextPageToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.GetReservationPurchaseRecommendationResponse) extends GetReservationPurchaseRecommendationResponse.ReadOnly {
    override def metadataValue: scala.Option[ReservationPurchaseRecommendationMetadata.ReadOnly] = scala.Option(impl.metadata()).map(value => ReservationPurchaseRecommendationMetadata.wrap(value))
    override def recommendationsValue: scala.Option[List[ReservationPurchaseRecommendation.ReadOnly]] = scala.Option(impl.recommendations()).map(value => value.asScala.map { item => 
      ReservationPurchaseRecommendation.wrap(item)
    }.toList)
    override def nextPageTokenValue: scala.Option[primitives.NextPageToken] = scala.Option(impl.nextPageToken()).map(value => value: primitives.NextPageToken)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.GetReservationPurchaseRecommendationResponse): ReadOnly = new Wrapper(impl)
}