package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetCostCategoriesResponse(nextPageToken: scala.Option[primitives.NextPageToken] = None, costCategoryNames: scala.Option[Iterable[primitives.CostCategoryName]] = None, costCategoryValues: scala.Option[Iterable[primitives.CostCategoryValue]] = None, returnSize: primitives.PageSize, totalSize: primitives.PageSize) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.GetCostCategoriesResponse = {
    import GetCostCategoriesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetCostCategoriesResponse.builder().optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).optionallyWith(costCategoryNames.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.costCategoryNames).optionallyWith(costCategoryValues.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.costCategoryValues).returnSize(returnSize: java.lang.Integer).totalSize(totalSize: java.lang.Integer).build()
  }
  def asReadOnly: GetCostCategoriesResponse.ReadOnly = GetCostCategoriesResponse.wrap(buildAwsValue())
}
object GetCostCategoriesResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.GetCostCategoriesResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetCostCategoriesResponse = GetCostCategoriesResponse(nextPageTokenValue.map(value => value), costCategoryNamesValue.map(value => value), costCategoryValuesValue.map(value => value), returnSizeValue, totalSizeValue)
    def nextPageTokenValue: scala.Option[primitives.NextPageToken]
    def costCategoryNamesValue: scala.Option[List[primitives.CostCategoryName]]
    def costCategoryValuesValue: scala.Option[List[primitives.CostCategoryValue]]
    def returnSizeValue: primitives.PageSize
    def totalSizeValue: primitives.PageSize
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextPageToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
    def costCategoryNames: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.CostCategoryName]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("costCategoryNames", costCategoryNamesValue)
    def costCategoryValues: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.CostCategoryValue]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("costCategoryValues", costCategoryValuesValue)
    def returnSize: ZIO[Any, Nothing, primitives.PageSize] = ZIO.succeed(returnSizeValue)
    def totalSize: ZIO[Any, Nothing, primitives.PageSize] = ZIO.succeed(totalSizeValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.GetCostCategoriesResponse) extends GetCostCategoriesResponse.ReadOnly {
    override def nextPageTokenValue: scala.Option[primitives.NextPageToken] = scala.Option(impl.nextPageToken()).map(value => value: primitives.NextPageToken)
    override def costCategoryNamesValue: scala.Option[List[primitives.CostCategoryName]] = scala.Option(impl.costCategoryNames()).map(value => value.asScala.map { item => 
      item: primitives.CostCategoryName
    }.toList)
    override def costCategoryValuesValue: scala.Option[List[primitives.CostCategoryValue]] = scala.Option(impl.costCategoryValues()).map(value => value.asScala.map { item => 
      item: primitives.CostCategoryValue
    }.toList)
    override def returnSizeValue: primitives.PageSize = impl.returnSize(): primitives.PageSize
    override def totalSizeValue: primitives.PageSize = impl.totalSize(): primitives.PageSize
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.GetCostCategoriesResponse): ReadOnly = new Wrapper(impl)
}