package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetAnomalySubscriptionsResponse(anomalySubscriptions: Iterable[AnomalySubscription], nextPageToken: scala.Option[primitives.NextPageToken] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.GetAnomalySubscriptionsResponse = {
    import GetAnomalySubscriptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetAnomalySubscriptionsResponse.builder().anomalySubscriptions(anomalySubscriptions.map { item => 
      item.buildAwsValue()
    }.asJavaCollection).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).build()
  }
  def asReadOnly: GetAnomalySubscriptionsResponse.ReadOnly = GetAnomalySubscriptionsResponse.wrap(buildAwsValue())
}
object GetAnomalySubscriptionsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.GetAnomalySubscriptionsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetAnomalySubscriptionsResponse = GetAnomalySubscriptionsResponse(anomalySubscriptionsValue.map { item => 
      item.editable
    }, nextPageTokenValue.map(value => value))
    def anomalySubscriptionsValue: List[AnomalySubscription.ReadOnly]
    def nextPageTokenValue: scala.Option[primitives.NextPageToken]
    def anomalySubscriptions: ZIO[Any, Nothing, List[AnomalySubscription.ReadOnly]] = ZIO.succeed(anomalySubscriptionsValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextPageToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.GetAnomalySubscriptionsResponse) extends GetAnomalySubscriptionsResponse.ReadOnly {
    override def anomalySubscriptionsValue: List[AnomalySubscription.ReadOnly] = impl.anomalySubscriptions().asScala.map { item => 
      AnomalySubscription.wrap(item)
    }.toList
    override def nextPageTokenValue: scala.Option[primitives.NextPageToken] = scala.Option(impl.nextPageToken()).map(value => value: primitives.NextPageToken)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.GetAnomalySubscriptionsResponse): ReadOnly = new Wrapper(impl)
}