package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetAnomaliesRequest(monitorArn: scala.Option[primitives.GenericString] = None, dateInterval: AnomalyDateInterval, feedback: scala.Option[AnomalyFeedbackType] = None, totalImpact: scala.Option[TotalImpactFilter] = None, nextPageToken: scala.Option[primitives.NextPageToken] = None, maxResults: scala.Option[primitives.PageSize] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.GetAnomaliesRequest = {
    import GetAnomaliesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetAnomaliesRequest.builder().optionallyWith(monitorArn.map(value => value: java.lang.String))(_.monitorArn).dateInterval(dateInterval.buildAwsValue()).optionallyWith(feedback.map(value => value.unwrap))(_.feedback).optionallyWith(totalImpact.map(value => value.buildAwsValue()))(_.totalImpact).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).optionallyWith(maxResults.map(value => value: java.lang.Integer))(_.maxResults).build()
  }
  def asReadOnly: GetAnomaliesRequest.ReadOnly = GetAnomaliesRequest.wrap(buildAwsValue())
}
object GetAnomaliesRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.GetAnomaliesRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetAnomaliesRequest = GetAnomaliesRequest(monitorArnValue.map(value => value), dateIntervalValue.editable, feedbackValue.map(value => value), totalImpactValue.map(value => value.editable), nextPageTokenValue.map(value => value), maxResultsValue.map(value => value))
    def monitorArnValue: scala.Option[primitives.GenericString]
    def dateIntervalValue: AnomalyDateInterval.ReadOnly
    def feedbackValue: scala.Option[AnomalyFeedbackType]
    def totalImpactValue: scala.Option[TotalImpactFilter.ReadOnly]
    def nextPageTokenValue: scala.Option[primitives.NextPageToken]
    def maxResultsValue: scala.Option[primitives.PageSize]
    def monitorArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("monitorArn", monitorArnValue)
    def dateInterval: ZIO[Any, Nothing, AnomalyDateInterval.ReadOnly] = ZIO.succeed(dateIntervalValue)
    def feedback: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, AnomalyFeedbackType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("feedback", feedbackValue)
    def totalImpact: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, TotalImpactFilter.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("totalImpact", totalImpactValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextPageToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
    def maxResults: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PageSize] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.GetAnomaliesRequest) extends GetAnomaliesRequest.ReadOnly {
    override def monitorArnValue: scala.Option[primitives.GenericString] = scala.Option(impl.monitorArn()).map(value => value: primitives.GenericString)
    override def dateIntervalValue: AnomalyDateInterval.ReadOnly = AnomalyDateInterval.wrap(impl.dateInterval())
    override def feedbackValue: scala.Option[AnomalyFeedbackType] = scala.Option(impl.feedback()).map(value => AnomalyFeedbackType.wrap(value))
    override def totalImpactValue: scala.Option[TotalImpactFilter.ReadOnly] = scala.Option(impl.totalImpact()).map(value => TotalImpactFilter.wrap(value))
    override def nextPageTokenValue: scala.Option[primitives.NextPageToken] = scala.Option(impl.nextPageToken()).map(value => value: primitives.NextPageToken)
    override def maxResultsValue: scala.Option[primitives.PageSize] = scala.Option(impl.maxResults()).map(value => value: primitives.PageSize)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.GetAnomaliesRequest): ReadOnly = new Wrapper(impl)
}