package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ForecastResult(timePeriod: scala.Option[DateInterval] = None, meanValue: scala.Option[primitives.GenericString] = None, predictionIntervalLowerBound: scala.Option[primitives.GenericString] = None, predictionIntervalUpperBound: scala.Option[primitives.GenericString] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.ForecastResult = {
    import ForecastResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.ForecastResult.builder().optionallyWith(timePeriod.map(value => value.buildAwsValue()))(_.timePeriod).optionallyWith(meanValue.map(value => value: java.lang.String))(_.meanValue).optionallyWith(predictionIntervalLowerBound.map(value => value: java.lang.String))(_.predictionIntervalLowerBound).optionallyWith(predictionIntervalUpperBound.map(value => value: java.lang.String))(_.predictionIntervalUpperBound).build()
  }
  def asReadOnly: ForecastResult.ReadOnly = ForecastResult.wrap(buildAwsValue())
}
object ForecastResult {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.ForecastResult] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ForecastResult = ForecastResult(timePeriodValue.map(value => value.editable), meanValueValue.map(value => value), predictionIntervalLowerBoundValue.map(value => value), predictionIntervalUpperBoundValue.map(value => value))
    def timePeriodValue: scala.Option[DateInterval.ReadOnly]
    def meanValueValue: scala.Option[primitives.GenericString]
    def predictionIntervalLowerBoundValue: scala.Option[primitives.GenericString]
    def predictionIntervalUpperBoundValue: scala.Option[primitives.GenericString]
    def timePeriod: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DateInterval.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("timePeriod", timePeriodValue)
    def meanValue: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("meanValue", meanValueValue)
    def predictionIntervalLowerBound: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("predictionIntervalLowerBound", predictionIntervalLowerBoundValue)
    def predictionIntervalUpperBound: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("predictionIntervalUpperBound", predictionIntervalUpperBoundValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.ForecastResult) extends ForecastResult.ReadOnly {
    override def timePeriodValue: scala.Option[DateInterval.ReadOnly] = scala.Option(impl.timePeriod()).map(value => DateInterval.wrap(value))
    override def meanValueValue: scala.Option[primitives.GenericString] = scala.Option(impl.meanValue()).map(value => value: primitives.GenericString)
    override def predictionIntervalLowerBoundValue: scala.Option[primitives.GenericString] = scala.Option(impl.predictionIntervalLowerBound()).map(value => value: primitives.GenericString)
    override def predictionIntervalUpperBoundValue: scala.Option[primitives.GenericString] = scala.Option(impl.predictionIntervalUpperBound()).map(value => value: primitives.GenericString)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.ForecastResult): ReadOnly = new Wrapper(impl)
}