package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Expression(or: scala.Option[Iterable[Expression]] = None, and: scala.Option[Iterable[Expression]] = None, not: scala.Option[Expression] = None, dimensions: scala.Option[DimensionValues] = None, tags: scala.Option[TagValues] = None, costCategories: scala.Option[CostCategoryValues] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.Expression = {
    import Expression.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.Expression.builder().optionallyWith(or.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.or).optionallyWith(and.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.and).optionallyWith(not.map(value => value.buildAwsValue()))(_.not).optionallyWith(dimensions.map(value => value.buildAwsValue()))(_.dimensions).optionallyWith(tags.map(value => value.buildAwsValue()))(_.tags).optionallyWith(costCategories.map(value => value.buildAwsValue()))(_.costCategories).build()
  }
  def asReadOnly: Expression.ReadOnly = Expression.wrap(buildAwsValue())
}
object Expression {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.Expression] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Expression = Expression(orValue.map(value => value.map { item => 
      item.editable
    }), andValue.map(value => value.map { item => 
      item.editable
    }), notValue.map(value => value.editable), dimensionsValue.map(value => value.editable), tagsValue.map(value => value.editable), costCategoriesValue.map(value => value.editable))
    def orValue: scala.Option[List[Expression.ReadOnly]]
    def andValue: scala.Option[List[Expression.ReadOnly]]
    def notValue: scala.Option[Expression.ReadOnly]
    def dimensionsValue: scala.Option[DimensionValues.ReadOnly]
    def tagsValue: scala.Option[TagValues.ReadOnly]
    def costCategoriesValue: scala.Option[CostCategoryValues.ReadOnly]
    def or: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Expression.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("or", orValue)
    def and: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Expression.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("and", andValue)
    def not: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Expression.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("not", notValue)
    def dimensions: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DimensionValues.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dimensions", dimensionsValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, TagValues.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    def costCategories: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, CostCategoryValues.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("costCategories", costCategoriesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.Expression) extends Expression.ReadOnly {
    override def orValue: scala.Option[List[Expression.ReadOnly]] = scala.Option(impl.or()).map(value => value.asScala.map { item => 
      Expression.wrap(item)
    }.toList)
    override def andValue: scala.Option[List[Expression.ReadOnly]] = scala.Option(impl.and()).map(value => value.asScala.map { item => 
      Expression.wrap(item)
    }.toList)
    override def notValue: scala.Option[Expression.ReadOnly] = scala.Option(impl.not()).map(value => Expression.wrap(value))
    override def dimensionsValue: scala.Option[DimensionValues.ReadOnly] = scala.Option(impl.dimensions()).map(value => DimensionValues.wrap(value))
    override def tagsValue: scala.Option[TagValues.ReadOnly] = scala.Option(impl.tags()).map(value => TagValues.wrap(value))
    override def costCategoriesValue: scala.Option[CostCategoryValues.ReadOnly] = scala.Option(impl.costCategories()).map(value => CostCategoryValues.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.Expression): ReadOnly = new Wrapper(impl)
}