package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ESInstanceDetails(instanceClass: scala.Option[primitives.GenericString] = None, instanceSize: scala.Option[primitives.GenericString] = None, region: scala.Option[primitives.GenericString] = None, currentGeneration: scala.Option[primitives.GenericBoolean] = None, sizeFlexEligible: scala.Option[primitives.GenericBoolean] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.ESInstanceDetails = {
    import ESInstanceDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.ESInstanceDetails.builder().optionallyWith(instanceClass.map(value => value: java.lang.String))(_.instanceClass).optionallyWith(instanceSize.map(value => value: java.lang.String))(_.instanceSize).optionallyWith(region.map(value => value: java.lang.String))(_.region).optionallyWith(currentGeneration.map(value => value: java.lang.Boolean))(_.currentGeneration).optionallyWith(sizeFlexEligible.map(value => value: java.lang.Boolean))(_.sizeFlexEligible).build()
  }
  def asReadOnly: ESInstanceDetails.ReadOnly = ESInstanceDetails.wrap(buildAwsValue())
}
object ESInstanceDetails {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.ESInstanceDetails] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ESInstanceDetails = ESInstanceDetails(instanceClassValue.map(value => value), instanceSizeValue.map(value => value), regionValue.map(value => value), currentGenerationValue.map(value => value), sizeFlexEligibleValue.map(value => value))
    def instanceClassValue: scala.Option[primitives.GenericString]
    def instanceSizeValue: scala.Option[primitives.GenericString]
    def regionValue: scala.Option[primitives.GenericString]
    def currentGenerationValue: scala.Option[primitives.GenericBoolean]
    def sizeFlexEligibleValue: scala.Option[primitives.GenericBoolean]
    def instanceClass: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("instanceClass", instanceClassValue)
    def instanceSize: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("instanceSize", instanceSizeValue)
    def region: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("region", regionValue)
    def currentGeneration: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericBoolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("currentGeneration", currentGenerationValue)
    def sizeFlexEligible: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericBoolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sizeFlexEligible", sizeFlexEligibleValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.ESInstanceDetails) extends ESInstanceDetails.ReadOnly {
    override def instanceClassValue: scala.Option[primitives.GenericString] = scala.Option(impl.instanceClass()).map(value => value: primitives.GenericString)
    override def instanceSizeValue: scala.Option[primitives.GenericString] = scala.Option(impl.instanceSize()).map(value => value: primitives.GenericString)
    override def regionValue: scala.Option[primitives.GenericString] = scala.Option(impl.region()).map(value => value: primitives.GenericString)
    override def currentGenerationValue: scala.Option[primitives.GenericBoolean] = scala.Option(impl.currentGeneration()).map(value => value: primitives.GenericBoolean)
    override def sizeFlexEligibleValue: scala.Option[primitives.GenericBoolean] = scala.Option(impl.sizeFlexEligible()).map(value => value: primitives.GenericBoolean)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.ESInstanceDetails): ReadOnly = new Wrapper(impl)
}