package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class EC2ResourceUtilization(maxCpuUtilizationPercentage: scala.Option[primitives.GenericString] = None, maxMemoryUtilizationPercentage: scala.Option[primitives.GenericString] = None, maxStorageUtilizationPercentage: scala.Option[primitives.GenericString] = None, ebsResourceUtilization: scala.Option[EBSResourceUtilization] = None, diskResourceUtilization: scala.Option[DiskResourceUtilization] = None, networkResourceUtilization: scala.Option[NetworkResourceUtilization] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.EC2ResourceUtilization = {
    import EC2ResourceUtilization.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.EC2ResourceUtilization.builder().optionallyWith(maxCpuUtilizationPercentage.map(value => value: java.lang.String))(_.maxCpuUtilizationPercentage).optionallyWith(maxMemoryUtilizationPercentage.map(value => value: java.lang.String))(_.maxMemoryUtilizationPercentage).optionallyWith(maxStorageUtilizationPercentage.map(value => value: java.lang.String))(_.maxStorageUtilizationPercentage).optionallyWith(ebsResourceUtilization.map(value => value.buildAwsValue()))(_.ebsResourceUtilization).optionallyWith(diskResourceUtilization.map(value => value.buildAwsValue()))(_.diskResourceUtilization).optionallyWith(networkResourceUtilization.map(value => value.buildAwsValue()))(_.networkResourceUtilization).build()
  }
  def asReadOnly: EC2ResourceUtilization.ReadOnly = EC2ResourceUtilization.wrap(buildAwsValue())
}
object EC2ResourceUtilization {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.EC2ResourceUtilization] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: EC2ResourceUtilization = EC2ResourceUtilization(maxCpuUtilizationPercentageValue.map(value => value), maxMemoryUtilizationPercentageValue.map(value => value), maxStorageUtilizationPercentageValue.map(value => value), ebsResourceUtilizationValue.map(value => value.editable), diskResourceUtilizationValue.map(value => value.editable), networkResourceUtilizationValue.map(value => value.editable))
    def maxCpuUtilizationPercentageValue: scala.Option[primitives.GenericString]
    def maxMemoryUtilizationPercentageValue: scala.Option[primitives.GenericString]
    def maxStorageUtilizationPercentageValue: scala.Option[primitives.GenericString]
    def ebsResourceUtilizationValue: scala.Option[EBSResourceUtilization.ReadOnly]
    def diskResourceUtilizationValue: scala.Option[DiskResourceUtilization.ReadOnly]
    def networkResourceUtilizationValue: scala.Option[NetworkResourceUtilization.ReadOnly]
    def maxCpuUtilizationPercentage: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxCpuUtilizationPercentage", maxCpuUtilizationPercentageValue)
    def maxMemoryUtilizationPercentage: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxMemoryUtilizationPercentage", maxMemoryUtilizationPercentageValue)
    def maxStorageUtilizationPercentage: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxStorageUtilizationPercentage", maxStorageUtilizationPercentageValue)
    def ebsResourceUtilization: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, EBSResourceUtilization.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ebsResourceUtilization", ebsResourceUtilizationValue)
    def diskResourceUtilization: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DiskResourceUtilization.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("diskResourceUtilization", diskResourceUtilizationValue)
    def networkResourceUtilization: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, NetworkResourceUtilization.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("networkResourceUtilization", networkResourceUtilizationValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.EC2ResourceUtilization) extends EC2ResourceUtilization.ReadOnly {
    override def maxCpuUtilizationPercentageValue: scala.Option[primitives.GenericString] = scala.Option(impl.maxCpuUtilizationPercentage()).map(value => value: primitives.GenericString)
    override def maxMemoryUtilizationPercentageValue: scala.Option[primitives.GenericString] = scala.Option(impl.maxMemoryUtilizationPercentage()).map(value => value: primitives.GenericString)
    override def maxStorageUtilizationPercentageValue: scala.Option[primitives.GenericString] = scala.Option(impl.maxStorageUtilizationPercentage()).map(value => value: primitives.GenericString)
    override def ebsResourceUtilizationValue: scala.Option[EBSResourceUtilization.ReadOnly] = scala.Option(impl.ebsResourceUtilization()).map(value => EBSResourceUtilization.wrap(value))
    override def diskResourceUtilizationValue: scala.Option[DiskResourceUtilization.ReadOnly] = scala.Option(impl.diskResourceUtilization()).map(value => DiskResourceUtilization.wrap(value))
    override def networkResourceUtilizationValue: scala.Option[NetworkResourceUtilization.ReadOnly] = scala.Option(impl.networkResourceUtilization()).map(value => NetworkResourceUtilization.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.EC2ResourceUtilization): ReadOnly = new Wrapper(impl)
}