package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class EC2ResourceDetails(hourlyOnDemandRate: scala.Option[primitives.GenericString] = None, instanceType: scala.Option[primitives.GenericString] = None, platform: scala.Option[primitives.GenericString] = None, region: scala.Option[primitives.GenericString] = None, sku: scala.Option[primitives.GenericString] = None, memory: scala.Option[primitives.GenericString] = None, networkPerformance: scala.Option[primitives.GenericString] = None, storage: scala.Option[primitives.GenericString] = None, vcpu: scala.Option[primitives.GenericString] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.EC2ResourceDetails = {
    import EC2ResourceDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.EC2ResourceDetails.builder().optionallyWith(hourlyOnDemandRate.map(value => value: java.lang.String))(_.hourlyOnDemandRate).optionallyWith(instanceType.map(value => value: java.lang.String))(_.instanceType).optionallyWith(platform.map(value => value: java.lang.String))(_.platform).optionallyWith(region.map(value => value: java.lang.String))(_.region).optionallyWith(sku.map(value => value: java.lang.String))(_.sku).optionallyWith(memory.map(value => value: java.lang.String))(_.memory).optionallyWith(networkPerformance.map(value => value: java.lang.String))(_.networkPerformance).optionallyWith(storage.map(value => value: java.lang.String))(_.storage).optionallyWith(vcpu.map(value => value: java.lang.String))(_.vcpu).build()
  }
  def asReadOnly: EC2ResourceDetails.ReadOnly = EC2ResourceDetails.wrap(buildAwsValue())
}
object EC2ResourceDetails {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.EC2ResourceDetails] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: EC2ResourceDetails = EC2ResourceDetails(hourlyOnDemandRateValue.map(value => value), instanceTypeValue.map(value => value), platformValue.map(value => value), regionValue.map(value => value), skuValue.map(value => value), memoryValue.map(value => value), networkPerformanceValue.map(value => value), storageValue.map(value => value), vcpuValue.map(value => value))
    def hourlyOnDemandRateValue: scala.Option[primitives.GenericString]
    def instanceTypeValue: scala.Option[primitives.GenericString]
    def platformValue: scala.Option[primitives.GenericString]
    def regionValue: scala.Option[primitives.GenericString]
    def skuValue: scala.Option[primitives.GenericString]
    def memoryValue: scala.Option[primitives.GenericString]
    def networkPerformanceValue: scala.Option[primitives.GenericString]
    def storageValue: scala.Option[primitives.GenericString]
    def vcpuValue: scala.Option[primitives.GenericString]
    def hourlyOnDemandRate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("hourlyOnDemandRate", hourlyOnDemandRateValue)
    def instanceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("instanceType", instanceTypeValue)
    def platform: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("platform", platformValue)
    def region: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("region", regionValue)
    def sku: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sku", skuValue)
    def memory: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("memory", memoryValue)
    def networkPerformance: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("networkPerformance", networkPerformanceValue)
    def storage: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("storage", storageValue)
    def vcpu: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vcpu", vcpuValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.EC2ResourceDetails) extends EC2ResourceDetails.ReadOnly {
    override def hourlyOnDemandRateValue: scala.Option[primitives.GenericString] = scala.Option(impl.hourlyOnDemandRate()).map(value => value: primitives.GenericString)
    override def instanceTypeValue: scala.Option[primitives.GenericString] = scala.Option(impl.instanceType()).map(value => value: primitives.GenericString)
    override def platformValue: scala.Option[primitives.GenericString] = scala.Option(impl.platform()).map(value => value: primitives.GenericString)
    override def regionValue: scala.Option[primitives.GenericString] = scala.Option(impl.region()).map(value => value: primitives.GenericString)
    override def skuValue: scala.Option[primitives.GenericString] = scala.Option(impl.sku()).map(value => value: primitives.GenericString)
    override def memoryValue: scala.Option[primitives.GenericString] = scala.Option(impl.memory()).map(value => value: primitives.GenericString)
    override def networkPerformanceValue: scala.Option[primitives.GenericString] = scala.Option(impl.networkPerformance()).map(value => value: primitives.GenericString)
    override def storageValue: scala.Option[primitives.GenericString] = scala.Option(impl.storage()).map(value => value: primitives.GenericString)
    override def vcpuValue: scala.Option[primitives.GenericString] = scala.Option(impl.vcpu()).map(value => value: primitives.GenericString)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.EC2ResourceDetails): ReadOnly = new Wrapper(impl)
}