package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DiskResourceUtilization(diskReadOpsPerSecond: scala.Option[primitives.GenericString] = None, diskWriteOpsPerSecond: scala.Option[primitives.GenericString] = None, diskReadBytesPerSecond: scala.Option[primitives.GenericString] = None, diskWriteBytesPerSecond: scala.Option[primitives.GenericString] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.DiskResourceUtilization = {
    import DiskResourceUtilization.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.DiskResourceUtilization.builder().optionallyWith(diskReadOpsPerSecond.map(value => value: java.lang.String))(_.diskReadOpsPerSecond).optionallyWith(diskWriteOpsPerSecond.map(value => value: java.lang.String))(_.diskWriteOpsPerSecond).optionallyWith(diskReadBytesPerSecond.map(value => value: java.lang.String))(_.diskReadBytesPerSecond).optionallyWith(diskWriteBytesPerSecond.map(value => value: java.lang.String))(_.diskWriteBytesPerSecond).build()
  }
  def asReadOnly: DiskResourceUtilization.ReadOnly = DiskResourceUtilization.wrap(buildAwsValue())
}
object DiskResourceUtilization {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.DiskResourceUtilization] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DiskResourceUtilization = DiskResourceUtilization(diskReadOpsPerSecondValue.map(value => value), diskWriteOpsPerSecondValue.map(value => value), diskReadBytesPerSecondValue.map(value => value), diskWriteBytesPerSecondValue.map(value => value))
    def diskReadOpsPerSecondValue: scala.Option[primitives.GenericString]
    def diskWriteOpsPerSecondValue: scala.Option[primitives.GenericString]
    def diskReadBytesPerSecondValue: scala.Option[primitives.GenericString]
    def diskWriteBytesPerSecondValue: scala.Option[primitives.GenericString]
    def diskReadOpsPerSecond: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("diskReadOpsPerSecond", diskReadOpsPerSecondValue)
    def diskWriteOpsPerSecond: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("diskWriteOpsPerSecond", diskWriteOpsPerSecondValue)
    def diskReadBytesPerSecond: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("diskReadBytesPerSecond", diskReadBytesPerSecondValue)
    def diskWriteBytesPerSecond: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("diskWriteBytesPerSecond", diskWriteBytesPerSecondValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.DiskResourceUtilization) extends DiskResourceUtilization.ReadOnly {
    override def diskReadOpsPerSecondValue: scala.Option[primitives.GenericString] = scala.Option(impl.diskReadOpsPerSecond()).map(value => value: primitives.GenericString)
    override def diskWriteOpsPerSecondValue: scala.Option[primitives.GenericString] = scala.Option(impl.diskWriteOpsPerSecond()).map(value => value: primitives.GenericString)
    override def diskReadBytesPerSecondValue: scala.Option[primitives.GenericString] = scala.Option(impl.diskReadBytesPerSecond()).map(value => value: primitives.GenericString)
    override def diskWriteBytesPerSecondValue: scala.Option[primitives.GenericString] = scala.Option(impl.diskWriteBytesPerSecond()).map(value => value: primitives.GenericString)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.DiskResourceUtilization): ReadOnly = new Wrapper(impl)
}