package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeCostCategoryDefinitionResponse(costCategory: scala.Option[CostCategory] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.DescribeCostCategoryDefinitionResponse = {
    import DescribeCostCategoryDefinitionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.DescribeCostCategoryDefinitionResponse.builder().optionallyWith(costCategory.map(value => value.buildAwsValue()))(_.costCategory).build()
  }
  def asReadOnly: DescribeCostCategoryDefinitionResponse.ReadOnly = DescribeCostCategoryDefinitionResponse.wrap(buildAwsValue())
}
object DescribeCostCategoryDefinitionResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.DescribeCostCategoryDefinitionResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeCostCategoryDefinitionResponse = DescribeCostCategoryDefinitionResponse(costCategoryValue.map(value => value.editable))
    def costCategoryValue: scala.Option[CostCategory.ReadOnly]
    def costCategory: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, CostCategory.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("costCategory", costCategoryValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.DescribeCostCategoryDefinitionResponse) extends DescribeCostCategoryDefinitionResponse.ReadOnly { override def costCategoryValue: scala.Option[CostCategory.ReadOnly] = scala.Option(impl.costCategory()).map(value => CostCategory.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.DescribeCostCategoryDefinitionResponse): ReadOnly = new Wrapper(impl)
}