package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteCostCategoryDefinitionResponse(costCategoryArn: scala.Option[primitives.Arn] = None, effectiveEnd: scala.Option[primitives.ZonedDateTime] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.DeleteCostCategoryDefinitionResponse = {
    import DeleteCostCategoryDefinitionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.DeleteCostCategoryDefinitionResponse.builder().optionallyWith(costCategoryArn.map(value => value: java.lang.String))(_.costCategoryArn).optionallyWith(effectiveEnd.map(value => value: java.lang.String))(_.effectiveEnd).build()
  }
  def asReadOnly: DeleteCostCategoryDefinitionResponse.ReadOnly = DeleteCostCategoryDefinitionResponse.wrap(buildAwsValue())
}
object DeleteCostCategoryDefinitionResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.DeleteCostCategoryDefinitionResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteCostCategoryDefinitionResponse = DeleteCostCategoryDefinitionResponse(costCategoryArnValue.map(value => value), effectiveEndValue.map(value => value))
    def costCategoryArnValue: scala.Option[primitives.Arn]
    def effectiveEndValue: scala.Option[primitives.ZonedDateTime]
    def costCategoryArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Arn] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("costCategoryArn", costCategoryArnValue)
    def effectiveEnd: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ZonedDateTime] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("effectiveEnd", effectiveEndValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.DeleteCostCategoryDefinitionResponse) extends DeleteCostCategoryDefinitionResponse.ReadOnly {
    override def costCategoryArnValue: scala.Option[primitives.Arn] = scala.Option(impl.costCategoryArn()).map(value => value: primitives.Arn)
    override def effectiveEndValue: scala.Option[primitives.ZonedDateTime] = scala.Option(impl.effectiveEnd()).map(value => value: primitives.ZonedDateTime)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.DeleteCostCategoryDefinitionResponse): ReadOnly = new Wrapper(impl)
}