package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteCostCategoryDefinitionRequest(costCategoryArn: primitives.Arn) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.DeleteCostCategoryDefinitionRequest = {
    import DeleteCostCategoryDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.DeleteCostCategoryDefinitionRequest.builder().costCategoryArn(costCategoryArn: java.lang.String).build()
  }
  def asReadOnly: DeleteCostCategoryDefinitionRequest.ReadOnly = DeleteCostCategoryDefinitionRequest.wrap(buildAwsValue())
}
object DeleteCostCategoryDefinitionRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.DeleteCostCategoryDefinitionRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteCostCategoryDefinitionRequest = DeleteCostCategoryDefinitionRequest(costCategoryArnValue)
    def costCategoryArnValue: primitives.Arn
    def costCategoryArn: ZIO[Any, Nothing, primitives.Arn] = ZIO.succeed(costCategoryArnValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.DeleteCostCategoryDefinitionRequest) extends DeleteCostCategoryDefinitionRequest.ReadOnly { override def costCategoryArnValue: primitives.Arn = impl.costCategoryArn(): primitives.Arn }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.DeleteCostCategoryDefinitionRequest): ReadOnly = new Wrapper(impl)
}