package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CurrentInstance(resourceId: scala.Option[primitives.GenericString] = None, instanceName: scala.Option[primitives.GenericString] = None, tags: scala.Option[Iterable[TagValues]] = None, resourceDetails: scala.Option[ResourceDetails] = None, resourceUtilization: scala.Option[ResourceUtilization] = None, reservationCoveredHoursInLookbackPeriod: scala.Option[primitives.GenericString] = None, savingsPlansCoveredHoursInLookbackPeriod: scala.Option[primitives.GenericString] = None, onDemandHoursInLookbackPeriod: scala.Option[primitives.GenericString] = None, totalRunningHoursInLookbackPeriod: scala.Option[primitives.GenericString] = None, monthlyCost: scala.Option[primitives.GenericString] = None, currencyCode: scala.Option[primitives.GenericString] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.CurrentInstance = {
    import CurrentInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.CurrentInstance.builder().optionallyWith(resourceId.map(value => value: java.lang.String))(_.resourceId).optionallyWith(instanceName.map(value => value: java.lang.String))(_.instanceName).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).optionallyWith(resourceDetails.map(value => value.buildAwsValue()))(_.resourceDetails).optionallyWith(resourceUtilization.map(value => value.buildAwsValue()))(_.resourceUtilization).optionallyWith(reservationCoveredHoursInLookbackPeriod.map(value => value: java.lang.String))(_.reservationCoveredHoursInLookbackPeriod).optionallyWith(savingsPlansCoveredHoursInLookbackPeriod.map(value => value: java.lang.String))(_.savingsPlansCoveredHoursInLookbackPeriod).optionallyWith(onDemandHoursInLookbackPeriod.map(value => value: java.lang.String))(_.onDemandHoursInLookbackPeriod).optionallyWith(totalRunningHoursInLookbackPeriod.map(value => value: java.lang.String))(_.totalRunningHoursInLookbackPeriod).optionallyWith(monthlyCost.map(value => value: java.lang.String))(_.monthlyCost).optionallyWith(currencyCode.map(value => value: java.lang.String))(_.currencyCode).build()
  }
  def asReadOnly: CurrentInstance.ReadOnly = CurrentInstance.wrap(buildAwsValue())
}
object CurrentInstance {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.CurrentInstance] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CurrentInstance = CurrentInstance(resourceIdValue.map(value => value), instanceNameValue.map(value => value), tagsValue.map(value => value.map { item => 
      item.editable
    }), resourceDetailsValue.map(value => value.editable), resourceUtilizationValue.map(value => value.editable), reservationCoveredHoursInLookbackPeriodValue.map(value => value), savingsPlansCoveredHoursInLookbackPeriodValue.map(value => value), onDemandHoursInLookbackPeriodValue.map(value => value), totalRunningHoursInLookbackPeriodValue.map(value => value), monthlyCostValue.map(value => value), currencyCodeValue.map(value => value))
    def resourceIdValue: scala.Option[primitives.GenericString]
    def instanceNameValue: scala.Option[primitives.GenericString]
    def tagsValue: scala.Option[List[TagValues.ReadOnly]]
    def resourceDetailsValue: scala.Option[ResourceDetails.ReadOnly]
    def resourceUtilizationValue: scala.Option[ResourceUtilization.ReadOnly]
    def reservationCoveredHoursInLookbackPeriodValue: scala.Option[primitives.GenericString]
    def savingsPlansCoveredHoursInLookbackPeriodValue: scala.Option[primitives.GenericString]
    def onDemandHoursInLookbackPeriodValue: scala.Option[primitives.GenericString]
    def totalRunningHoursInLookbackPeriodValue: scala.Option[primitives.GenericString]
    def monthlyCostValue: scala.Option[primitives.GenericString]
    def currencyCodeValue: scala.Option[primitives.GenericString]
    def resourceId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceId", resourceIdValue)
    def instanceName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("instanceName", instanceNameValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[TagValues.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    def resourceDetails: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceDetails.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceDetails", resourceDetailsValue)
    def resourceUtilization: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceUtilization.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceUtilization", resourceUtilizationValue)
    def reservationCoveredHoursInLookbackPeriod: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("reservationCoveredHoursInLookbackPeriod", reservationCoveredHoursInLookbackPeriodValue)
    def savingsPlansCoveredHoursInLookbackPeriod: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("savingsPlansCoveredHoursInLookbackPeriod", savingsPlansCoveredHoursInLookbackPeriodValue)
    def onDemandHoursInLookbackPeriod: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("onDemandHoursInLookbackPeriod", onDemandHoursInLookbackPeriodValue)
    def totalRunningHoursInLookbackPeriod: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("totalRunningHoursInLookbackPeriod", totalRunningHoursInLookbackPeriodValue)
    def monthlyCost: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("monthlyCost", monthlyCostValue)
    def currencyCode: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("currencyCode", currencyCodeValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.CurrentInstance) extends CurrentInstance.ReadOnly {
    override def resourceIdValue: scala.Option[primitives.GenericString] = scala.Option(impl.resourceId()).map(value => value: primitives.GenericString)
    override def instanceNameValue: scala.Option[primitives.GenericString] = scala.Option(impl.instanceName()).map(value => value: primitives.GenericString)
    override def tagsValue: scala.Option[List[TagValues.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      TagValues.wrap(item)
    }.toList)
    override def resourceDetailsValue: scala.Option[ResourceDetails.ReadOnly] = scala.Option(impl.resourceDetails()).map(value => ResourceDetails.wrap(value))
    override def resourceUtilizationValue: scala.Option[ResourceUtilization.ReadOnly] = scala.Option(impl.resourceUtilization()).map(value => ResourceUtilization.wrap(value))
    override def reservationCoveredHoursInLookbackPeriodValue: scala.Option[primitives.GenericString] = scala.Option(impl.reservationCoveredHoursInLookbackPeriod()).map(value => value: primitives.GenericString)
    override def savingsPlansCoveredHoursInLookbackPeriodValue: scala.Option[primitives.GenericString] = scala.Option(impl.savingsPlansCoveredHoursInLookbackPeriod()).map(value => value: primitives.GenericString)
    override def onDemandHoursInLookbackPeriodValue: scala.Option[primitives.GenericString] = scala.Option(impl.onDemandHoursInLookbackPeriod()).map(value => value: primitives.GenericString)
    override def totalRunningHoursInLookbackPeriodValue: scala.Option[primitives.GenericString] = scala.Option(impl.totalRunningHoursInLookbackPeriod()).map(value => value: primitives.GenericString)
    override def monthlyCostValue: scala.Option[primitives.GenericString] = scala.Option(impl.monthlyCost()).map(value => value: primitives.GenericString)
    override def currencyCodeValue: scala.Option[primitives.GenericString] = scala.Option(impl.currencyCode()).map(value => value: primitives.GenericString)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.CurrentInstance): ReadOnly = new Wrapper(impl)
}