package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Coverage(coverageHours: scala.Option[CoverageHours] = None, coverageNormalizedUnits: scala.Option[CoverageNormalizedUnits] = None, coverageCost: scala.Option[CoverageCost] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.Coverage = {
    import Coverage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.Coverage.builder().optionallyWith(coverageHours.map(value => value.buildAwsValue()))(_.coverageHours).optionallyWith(coverageNormalizedUnits.map(value => value.buildAwsValue()))(_.coverageNormalizedUnits).optionallyWith(coverageCost.map(value => value.buildAwsValue()))(_.coverageCost).build()
  }
  def asReadOnly: Coverage.ReadOnly = Coverage.wrap(buildAwsValue())
}
object Coverage {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.Coverage] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Coverage = Coverage(coverageHoursValue.map(value => value.editable), coverageNormalizedUnitsValue.map(value => value.editable), coverageCostValue.map(value => value.editable))
    def coverageHoursValue: scala.Option[CoverageHours.ReadOnly]
    def coverageNormalizedUnitsValue: scala.Option[CoverageNormalizedUnits.ReadOnly]
    def coverageCostValue: scala.Option[CoverageCost.ReadOnly]
    def coverageHours: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, CoverageHours.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("coverageHours", coverageHoursValue)
    def coverageNormalizedUnits: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, CoverageNormalizedUnits.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("coverageNormalizedUnits", coverageNormalizedUnitsValue)
    def coverageCost: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, CoverageCost.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("coverageCost", coverageCostValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.Coverage) extends Coverage.ReadOnly {
    override def coverageHoursValue: scala.Option[CoverageHours.ReadOnly] = scala.Option(impl.coverageHours()).map(value => CoverageHours.wrap(value))
    override def coverageNormalizedUnitsValue: scala.Option[CoverageNormalizedUnits.ReadOnly] = scala.Option(impl.coverageNormalizedUnits()).map(value => CoverageNormalizedUnits.wrap(value))
    override def coverageCostValue: scala.Option[CoverageCost.ReadOnly] = scala.Option(impl.coverageCost()).map(value => CoverageCost.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.Coverage): ReadOnly = new Wrapper(impl)
}