package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait CostCategoryStatus { def unwrap: software.amazon.awssdk.services.costexplorer.model.CostCategoryStatus }
object CostCategoryStatus {
  def wrap(value: software.amazon.awssdk.services.costexplorer.model.CostCategoryStatus): CostCategoryStatus = value match {
    case software.amazon.awssdk.services.costexplorer.model.CostCategoryStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.costexplorer.model.CostCategoryStatus.PROCESSING =>
      val r = PROCESSING
      r
    case software.amazon.awssdk.services.costexplorer.model.CostCategoryStatus.APPLIED =>
      val r = APPLIED
      r
  }
  case object unknownToSdkVersion extends CostCategoryStatus { override def unwrap: software.amazon.awssdk.services.costexplorer.model.CostCategoryStatus = software.amazon.awssdk.services.costexplorer.model.CostCategoryStatus.UNKNOWN_TO_SDK_VERSION }
  case object PROCESSING extends CostCategoryStatus { override def unwrap: software.amazon.awssdk.services.costexplorer.model.CostCategoryStatus = software.amazon.awssdk.services.costexplorer.model.CostCategoryStatus.PROCESSING }
  case object APPLIED extends CostCategoryStatus { override def unwrap: software.amazon.awssdk.services.costexplorer.model.CostCategoryStatus = software.amazon.awssdk.services.costexplorer.model.CostCategoryStatus.APPLIED }
}