package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CostCategoryInheritedValueDimension(dimensionName: scala.Option[CostCategoryInheritedValueDimensionName] = None, dimensionKey: scala.Option[primitives.GenericString] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.CostCategoryInheritedValueDimension = {
    import CostCategoryInheritedValueDimension.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.CostCategoryInheritedValueDimension.builder().optionallyWith(dimensionName.map(value => value.unwrap))(_.dimensionName).optionallyWith(dimensionKey.map(value => value: java.lang.String))(_.dimensionKey).build()
  }
  def asReadOnly: CostCategoryInheritedValueDimension.ReadOnly = CostCategoryInheritedValueDimension.wrap(buildAwsValue())
}
object CostCategoryInheritedValueDimension {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.CostCategoryInheritedValueDimension] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CostCategoryInheritedValueDimension = CostCategoryInheritedValueDimension(dimensionNameValue.map(value => value), dimensionKeyValue.map(value => value))
    def dimensionNameValue: scala.Option[CostCategoryInheritedValueDimensionName]
    def dimensionKeyValue: scala.Option[primitives.GenericString]
    def dimensionName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, CostCategoryInheritedValueDimensionName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dimensionName", dimensionNameValue)
    def dimensionKey: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dimensionKey", dimensionKeyValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.CostCategoryInheritedValueDimension) extends CostCategoryInheritedValueDimension.ReadOnly {
    override def dimensionNameValue: scala.Option[CostCategoryInheritedValueDimensionName] = scala.Option(impl.dimensionName()).map(value => CostCategoryInheritedValueDimensionName.wrap(value))
    override def dimensionKeyValue: scala.Option[primitives.GenericString] = scala.Option(impl.dimensionKey()).map(value => value: primitives.GenericString)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.CostCategoryInheritedValueDimension): ReadOnly = new Wrapper(impl)
}