package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class AnomalyMonitor(monitorArn: scala.Option[primitives.GenericString] = None, monitorName: primitives.GenericString, creationDate: scala.Option[primitives.YearMonthDay] = None, lastUpdatedDate: scala.Option[primitives.YearMonthDay] = None, lastEvaluatedDate: scala.Option[primitives.YearMonthDay] = None, monitorType: MonitorType, monitorDimension: scala.Option[MonitorDimension] = None, monitorSpecification: scala.Option[Expression] = None, dimensionalValueCount: scala.Option[primitives.NonNegativeInteger] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.AnomalyMonitor = {
    import AnomalyMonitor.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.AnomalyMonitor.builder().optionallyWith(monitorArn.map(value => value: java.lang.String))(_.monitorArn).monitorName(monitorName: java.lang.String).optionallyWith(creationDate.map(value => value: java.lang.String))(_.creationDate).optionallyWith(lastUpdatedDate.map(value => value: java.lang.String))(_.lastUpdatedDate).optionallyWith(lastEvaluatedDate.map(value => value: java.lang.String))(_.lastEvaluatedDate).monitorType(monitorType.unwrap).optionallyWith(monitorDimension.map(value => value.unwrap))(_.monitorDimension).optionallyWith(monitorSpecification.map(value => value.buildAwsValue()))(_.monitorSpecification).optionallyWith(dimensionalValueCount.map(value => value: java.lang.Integer))(_.dimensionalValueCount).build()
  }
  def asReadOnly: AnomalyMonitor.ReadOnly = AnomalyMonitor.wrap(buildAwsValue())
}
object AnomalyMonitor {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.AnomalyMonitor] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: AnomalyMonitor = AnomalyMonitor(monitorArnValue.map(value => value), monitorNameValue, creationDateValue.map(value => value), lastUpdatedDateValue.map(value => value), lastEvaluatedDateValue.map(value => value), monitorTypeValue, monitorDimensionValue.map(value => value), monitorSpecificationValue.map(value => value.editable), dimensionalValueCountValue.map(value => value))
    def monitorArnValue: scala.Option[primitives.GenericString]
    def monitorNameValue: primitives.GenericString
    def creationDateValue: scala.Option[primitives.YearMonthDay]
    def lastUpdatedDateValue: scala.Option[primitives.YearMonthDay]
    def lastEvaluatedDateValue: scala.Option[primitives.YearMonthDay]
    def monitorTypeValue: MonitorType
    def monitorDimensionValue: scala.Option[MonitorDimension]
    def monitorSpecificationValue: scala.Option[Expression.ReadOnly]
    def dimensionalValueCountValue: scala.Option[primitives.NonNegativeInteger]
    def monitorArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("monitorArn", monitorArnValue)
    def monitorName: ZIO[Any, Nothing, primitives.GenericString] = ZIO.succeed(monitorNameValue)
    def creationDate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.YearMonthDay] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("creationDate", creationDateValue)
    def lastUpdatedDate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.YearMonthDay] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lastUpdatedDate", lastUpdatedDateValue)
    def lastEvaluatedDate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.YearMonthDay] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lastEvaluatedDate", lastEvaluatedDateValue)
    def monitorType: ZIO[Any, Nothing, MonitorType] = ZIO.succeed(monitorTypeValue)
    def monitorDimension: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, MonitorDimension] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("monitorDimension", monitorDimensionValue)
    def monitorSpecification: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Expression.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("monitorSpecification", monitorSpecificationValue)
    def dimensionalValueCount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonNegativeInteger] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dimensionalValueCount", dimensionalValueCountValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.AnomalyMonitor) extends AnomalyMonitor.ReadOnly {
    override def monitorArnValue: scala.Option[primitives.GenericString] = scala.Option(impl.monitorArn()).map(value => value: primitives.GenericString)
    override def monitorNameValue: primitives.GenericString = impl.monitorName(): primitives.GenericString
    override def creationDateValue: scala.Option[primitives.YearMonthDay] = scala.Option(impl.creationDate()).map(value => value: primitives.YearMonthDay)
    override def lastUpdatedDateValue: scala.Option[primitives.YearMonthDay] = scala.Option(impl.lastUpdatedDate()).map(value => value: primitives.YearMonthDay)
    override def lastEvaluatedDateValue: scala.Option[primitives.YearMonthDay] = scala.Option(impl.lastEvaluatedDate()).map(value => value: primitives.YearMonthDay)
    override def monitorTypeValue: MonitorType = MonitorType.wrap(impl.monitorType())
    override def monitorDimensionValue: scala.Option[MonitorDimension] = scala.Option(impl.monitorDimension()).map(value => MonitorDimension.wrap(value))
    override def monitorSpecificationValue: scala.Option[Expression.ReadOnly] = scala.Option(impl.monitorSpecification()).map(value => Expression.wrap(value))
    override def dimensionalValueCountValue: scala.Option[primitives.NonNegativeInteger] = scala.Option(impl.dimensionalValueCount()).map(value => value: primitives.NonNegativeInteger)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.AnomalyMonitor): ReadOnly = new Wrapper(impl)
}