package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class TerminateRecommendationDetail(estimatedMonthlySavings: scala.Option[primitives.GenericString] = None, currencyCode: scala.Option[primitives.GenericString] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.TerminateRecommendationDetail = {
    import TerminateRecommendationDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.TerminateRecommendationDetail.builder().optionallyWith(estimatedMonthlySavings.map(value => value: java.lang.String))(_.estimatedMonthlySavings).optionallyWith(currencyCode.map(value => value: java.lang.String))(_.currencyCode).build()
  }
  def asReadOnly: TerminateRecommendationDetail.ReadOnly = TerminateRecommendationDetail.wrap(buildAwsValue())
}
object TerminateRecommendationDetail {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.TerminateRecommendationDetail] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: TerminateRecommendationDetail = TerminateRecommendationDetail(estimatedMonthlySavingsValue.map(value => value), currencyCodeValue.map(value => value))
    def estimatedMonthlySavingsValue: scala.Option[primitives.GenericString]
    def currencyCodeValue: scala.Option[primitives.GenericString]
    def estimatedMonthlySavings: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("estimatedMonthlySavings", estimatedMonthlySavingsValue)
    def currencyCode: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("currencyCode", currencyCodeValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.TerminateRecommendationDetail) extends TerminateRecommendationDetail.ReadOnly {
    override def estimatedMonthlySavingsValue: scala.Option[primitives.GenericString] = scala.Option(impl.estimatedMonthlySavings()).map(value => value: primitives.GenericString)
    override def currencyCodeValue: scala.Option[primitives.GenericString] = scala.Option(impl.currencyCode()).map(value => value: primitives.GenericString)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.TerminateRecommendationDetail): ReadOnly = new Wrapper(impl)
}