package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class SavingsPlansUtilizationAggregates(utilization: SavingsPlansUtilization, savings: scala.Option[SavingsPlansSavings] = None, amortizedCommitment: scala.Option[SavingsPlansAmortizedCommitment] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilizationAggregates = {
    import SavingsPlansUtilizationAggregates.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilizationAggregates.builder().utilization(utilization.buildAwsValue()).optionallyWith(savings.map(value => value.buildAwsValue()))(_.savings).optionallyWith(amortizedCommitment.map(value => value.buildAwsValue()))(_.amortizedCommitment).build()
  }
  def asReadOnly: SavingsPlansUtilizationAggregates.ReadOnly = SavingsPlansUtilizationAggregates.wrap(buildAwsValue())
}
object SavingsPlansUtilizationAggregates {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilizationAggregates] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: SavingsPlansUtilizationAggregates = SavingsPlansUtilizationAggregates(utilizationValue.editable, savingsValue.map(value => value.editable), amortizedCommitmentValue.map(value => value.editable))
    def utilizationValue: SavingsPlansUtilization.ReadOnly
    def savingsValue: scala.Option[SavingsPlansSavings.ReadOnly]
    def amortizedCommitmentValue: scala.Option[SavingsPlansAmortizedCommitment.ReadOnly]
    def utilization: ZIO[Any, Nothing, SavingsPlansUtilization.ReadOnly] = ZIO.succeed(utilizationValue)
    def savings: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, SavingsPlansSavings.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("savings", savingsValue)
    def amortizedCommitment: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, SavingsPlansAmortizedCommitment.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("amortizedCommitment", amortizedCommitmentValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilizationAggregates) extends SavingsPlansUtilizationAggregates.ReadOnly {
    override def utilizationValue: SavingsPlansUtilization.ReadOnly = SavingsPlansUtilization.wrap(impl.utilization())
    override def savingsValue: scala.Option[SavingsPlansSavings.ReadOnly] = scala.Option(impl.savings()).map(value => SavingsPlansSavings.wrap(value))
    override def amortizedCommitmentValue: scala.Option[SavingsPlansAmortizedCommitment.ReadOnly] = scala.Option(impl.amortizedCommitment()).map(value => SavingsPlansAmortizedCommitment.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilizationAggregates): ReadOnly = new Wrapper(impl)
}