package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ResourceDetails(ec2ResourceDetails: scala.Option[EC2ResourceDetails] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.ResourceDetails = {
    import ResourceDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.ResourceDetails.builder().optionallyWith(ec2ResourceDetails.map(value => value.buildAwsValue()))(_.ec2ResourceDetails).build()
  }
  def asReadOnly: ResourceDetails.ReadOnly = ResourceDetails.wrap(buildAwsValue())
}
object ResourceDetails {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.ResourceDetails] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ResourceDetails = ResourceDetails(ec2ResourceDetailsValue.map(value => value.editable))
    def ec2ResourceDetailsValue: scala.Option[EC2ResourceDetails.ReadOnly]
    def ec2ResourceDetails: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, EC2ResourceDetails.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ec2ResourceDetails", ec2ResourceDetailsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.ResourceDetails) extends ResourceDetails.ReadOnly { override def ec2ResourceDetailsValue: scala.Option[EC2ResourceDetails.ReadOnly] = scala.Option(impl.ec2ResourceDetails()).map(value => EC2ResourceDetails.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.ResourceDetails): ReadOnly = new Wrapper(impl)
}