package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ProvideAnomalyFeedbackRequest(anomalyId: primitives.GenericString, feedback: AnomalyFeedbackType) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.ProvideAnomalyFeedbackRequest = {
    import ProvideAnomalyFeedbackRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.ProvideAnomalyFeedbackRequest.builder().anomalyId(anomalyId: java.lang.String).feedback(feedback.unwrap).build()
  }
  def asReadOnly: ProvideAnomalyFeedbackRequest.ReadOnly = ProvideAnomalyFeedbackRequest.wrap(buildAwsValue())
}
object ProvideAnomalyFeedbackRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.ProvideAnomalyFeedbackRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ProvideAnomalyFeedbackRequest = ProvideAnomalyFeedbackRequest(anomalyIdValue, feedbackValue)
    def anomalyIdValue: primitives.GenericString
    def feedbackValue: AnomalyFeedbackType
    def anomalyId: ZIO[Any, Nothing, primitives.GenericString] = ZIO.succeed(anomalyIdValue)
    def feedback: ZIO[Any, Nothing, AnomalyFeedbackType] = ZIO.succeed(feedbackValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.ProvideAnomalyFeedbackRequest) extends ProvideAnomalyFeedbackRequest.ReadOnly {
    override def anomalyIdValue: primitives.GenericString = impl.anomalyId(): primitives.GenericString
    override def feedbackValue: AnomalyFeedbackType = AnomalyFeedbackType.wrap(impl.feedback())
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.ProvideAnomalyFeedbackRequest): ReadOnly = new Wrapper(impl)
}