package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetCostForecastResponse(total: scala.Option[MetricValue] = None, forecastResultsByTime: scala.Option[Iterable[ForecastResult]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.GetCostForecastResponse = {
    import GetCostForecastResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetCostForecastResponse.builder().optionallyWith(total.map(value => value.buildAwsValue()))(_.total).optionallyWith(forecastResultsByTime.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.forecastResultsByTime).build()
  }
  def asReadOnly: GetCostForecastResponse.ReadOnly = GetCostForecastResponse.wrap(buildAwsValue())
}
object GetCostForecastResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.GetCostForecastResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetCostForecastResponse = GetCostForecastResponse(totalValue.map(value => value.editable), forecastResultsByTimeValue.map(value => value.map { item => 
      item.editable
    }))
    def totalValue: scala.Option[MetricValue.ReadOnly]
    def forecastResultsByTimeValue: scala.Option[List[ForecastResult.ReadOnly]]
    def total: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, MetricValue.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("total", totalValue)
    def forecastResultsByTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[ForecastResult.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("forecastResultsByTime", forecastResultsByTimeValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.GetCostForecastResponse) extends GetCostForecastResponse.ReadOnly {
    override def totalValue: scala.Option[MetricValue.ReadOnly] = scala.Option(impl.total()).map(value => MetricValue.wrap(value))
    override def forecastResultsByTimeValue: scala.Option[List[ForecastResult.ReadOnly]] = scala.Option(impl.forecastResultsByTime()).map(value => value.asScala.map { item => 
      ForecastResult.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.GetCostForecastResponse): ReadOnly = new Wrapper(impl)
}