package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class EC2InstanceDetails(family: scala.Option[primitives.GenericString] = None, instanceType: scala.Option[primitives.GenericString] = None, region: scala.Option[primitives.GenericString] = None, availabilityZone: scala.Option[primitives.GenericString] = None, platform: scala.Option[primitives.GenericString] = None, tenancy: scala.Option[primitives.GenericString] = None, currentGeneration: scala.Option[primitives.GenericBoolean] = None, sizeFlexEligible: scala.Option[primitives.GenericBoolean] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.EC2InstanceDetails = {
    import EC2InstanceDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.EC2InstanceDetails.builder().optionallyWith(family.map(value => value: java.lang.String))(_.family).optionallyWith(instanceType.map(value => value: java.lang.String))(_.instanceType).optionallyWith(region.map(value => value: java.lang.String))(_.region).optionallyWith(availabilityZone.map(value => value: java.lang.String))(_.availabilityZone).optionallyWith(platform.map(value => value: java.lang.String))(_.platform).optionallyWith(tenancy.map(value => value: java.lang.String))(_.tenancy).optionallyWith(currentGeneration.map(value => value: java.lang.Boolean))(_.currentGeneration).optionallyWith(sizeFlexEligible.map(value => value: java.lang.Boolean))(_.sizeFlexEligible).build()
  }
  def asReadOnly: EC2InstanceDetails.ReadOnly = EC2InstanceDetails.wrap(buildAwsValue())
}
object EC2InstanceDetails {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.EC2InstanceDetails] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: EC2InstanceDetails = EC2InstanceDetails(familyValue.map(value => value), instanceTypeValue.map(value => value), regionValue.map(value => value), availabilityZoneValue.map(value => value), platformValue.map(value => value), tenancyValue.map(value => value), currentGenerationValue.map(value => value), sizeFlexEligibleValue.map(value => value))
    def familyValue: scala.Option[primitives.GenericString]
    def instanceTypeValue: scala.Option[primitives.GenericString]
    def regionValue: scala.Option[primitives.GenericString]
    def availabilityZoneValue: scala.Option[primitives.GenericString]
    def platformValue: scala.Option[primitives.GenericString]
    def tenancyValue: scala.Option[primitives.GenericString]
    def currentGenerationValue: scala.Option[primitives.GenericBoolean]
    def sizeFlexEligibleValue: scala.Option[primitives.GenericBoolean]
    def family: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("family", familyValue)
    def instanceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("instanceType", instanceTypeValue)
    def region: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("region", regionValue)
    def availabilityZone: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("availabilityZone", availabilityZoneValue)
    def platform: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("platform", platformValue)
    def tenancy: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tenancy", tenancyValue)
    def currentGeneration: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericBoolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("currentGeneration", currentGenerationValue)
    def sizeFlexEligible: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericBoolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sizeFlexEligible", sizeFlexEligibleValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.EC2InstanceDetails) extends EC2InstanceDetails.ReadOnly {
    override def familyValue: scala.Option[primitives.GenericString] = scala.Option(impl.family()).map(value => value: primitives.GenericString)
    override def instanceTypeValue: scala.Option[primitives.GenericString] = scala.Option(impl.instanceType()).map(value => value: primitives.GenericString)
    override def regionValue: scala.Option[primitives.GenericString] = scala.Option(impl.region()).map(value => value: primitives.GenericString)
    override def availabilityZoneValue: scala.Option[primitives.GenericString] = scala.Option(impl.availabilityZone()).map(value => value: primitives.GenericString)
    override def platformValue: scala.Option[primitives.GenericString] = scala.Option(impl.platform()).map(value => value: primitives.GenericString)
    override def tenancyValue: scala.Option[primitives.GenericString] = scala.Option(impl.tenancy()).map(value => value: primitives.GenericString)
    override def currentGenerationValue: scala.Option[primitives.GenericBoolean] = scala.Option(impl.currentGeneration()).map(value => value: primitives.GenericBoolean)
    override def sizeFlexEligibleValue: scala.Option[primitives.GenericBoolean] = scala.Option(impl.sizeFlexEligible()).map(value => value: primitives.GenericBoolean)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.EC2InstanceDetails): ReadOnly = new Wrapper(impl)
}