package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteAnomalySubscriptionRequest(subscriptionArn: primitives.GenericString) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.DeleteAnomalySubscriptionRequest = {
    import DeleteAnomalySubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.DeleteAnomalySubscriptionRequest.builder().subscriptionArn(subscriptionArn: java.lang.String).build()
  }
  def asReadOnly: DeleteAnomalySubscriptionRequest.ReadOnly = DeleteAnomalySubscriptionRequest.wrap(buildAwsValue())
}
object DeleteAnomalySubscriptionRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.DeleteAnomalySubscriptionRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteAnomalySubscriptionRequest = DeleteAnomalySubscriptionRequest(subscriptionArnValue)
    def subscriptionArnValue: primitives.GenericString
    def subscriptionArn: ZIO[Any, Nothing, primitives.GenericString] = ZIO.succeed(subscriptionArnValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.DeleteAnomalySubscriptionRequest) extends DeleteAnomalySubscriptionRequest.ReadOnly { override def subscriptionArnValue: primitives.GenericString = impl.subscriptionArn(): primitives.GenericString }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.DeleteAnomalySubscriptionRequest): ReadOnly = new Wrapper(impl)
}