package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CostCategory(costCategoryArn: primitives.Arn, effectiveStart: primitives.ZonedDateTime, effectiveEnd: scala.Option[primitives.ZonedDateTime] = None, name: primitives.CostCategoryName, ruleVersion: CostCategoryRuleVersion, rules: Iterable[CostCategoryRule], processingStatus: scala.Option[Iterable[CostCategoryProcessingStatus]] = None, defaultValue: scala.Option[primitives.CostCategoryValue] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.CostCategory = {
    import CostCategory.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.CostCategory.builder().costCategoryArn(costCategoryArn: java.lang.String).effectiveStart(effectiveStart: java.lang.String).optionallyWith(effectiveEnd.map(value => value: java.lang.String))(_.effectiveEnd).name(name: java.lang.String).ruleVersion(ruleVersion.unwrap).rules(rules.map { item => 
      item.buildAwsValue()
    }.asJavaCollection).optionallyWith(processingStatus.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.processingStatus).optionallyWith(defaultValue.map(value => value: java.lang.String))(_.defaultValue).build()
  }
  def asReadOnly: CostCategory.ReadOnly = CostCategory.wrap(buildAwsValue())
}
object CostCategory {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.CostCategory] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CostCategory = CostCategory(costCategoryArnValue, effectiveStartValue, effectiveEndValue.map(value => value), nameValue, ruleVersionValue, rulesValue.map { item => 
      item.editable
    }, processingStatusValue.map(value => value.map { item => 
      item.editable
    }), defaultValueValue.map(value => value))
    def costCategoryArnValue: primitives.Arn
    def effectiveStartValue: primitives.ZonedDateTime
    def effectiveEndValue: scala.Option[primitives.ZonedDateTime]
    def nameValue: primitives.CostCategoryName
    def ruleVersionValue: CostCategoryRuleVersion
    def rulesValue: List[CostCategoryRule.ReadOnly]
    def processingStatusValue: scala.Option[List[CostCategoryProcessingStatus.ReadOnly]]
    def defaultValueValue: scala.Option[primitives.CostCategoryValue]
    def costCategoryArn: ZIO[Any, Nothing, primitives.Arn] = ZIO.succeed(costCategoryArnValue)
    def effectiveStart: ZIO[Any, Nothing, primitives.ZonedDateTime] = ZIO.succeed(effectiveStartValue)
    def effectiveEnd: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ZonedDateTime] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("effectiveEnd", effectiveEndValue)
    def name: ZIO[Any, Nothing, primitives.CostCategoryName] = ZIO.succeed(nameValue)
    def ruleVersion: ZIO[Any, Nothing, CostCategoryRuleVersion] = ZIO.succeed(ruleVersionValue)
    def rules: ZIO[Any, Nothing, List[CostCategoryRule.ReadOnly]] = ZIO.succeed(rulesValue)
    def processingStatus: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[CostCategoryProcessingStatus.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("processingStatus", processingStatusValue)
    def defaultValue: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.CostCategoryValue] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("defaultValue", defaultValueValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.CostCategory) extends CostCategory.ReadOnly {
    override def costCategoryArnValue: primitives.Arn = impl.costCategoryArn(): primitives.Arn
    override def effectiveStartValue: primitives.ZonedDateTime = impl.effectiveStart(): primitives.ZonedDateTime
    override def effectiveEndValue: scala.Option[primitives.ZonedDateTime] = scala.Option(impl.effectiveEnd()).map(value => value: primitives.ZonedDateTime)
    override def nameValue: primitives.CostCategoryName = impl.name(): primitives.CostCategoryName
    override def ruleVersionValue: CostCategoryRuleVersion = CostCategoryRuleVersion.wrap(impl.ruleVersion())
    override def rulesValue: List[CostCategoryRule.ReadOnly] = impl.rules().asScala.map { item => 
      CostCategoryRule.wrap(item)
    }.toList
    override def processingStatusValue: scala.Option[List[CostCategoryProcessingStatus.ReadOnly]] = scala.Option(impl.processingStatus()).map(value => value.asScala.map { item => 
      CostCategoryProcessingStatus.wrap(item)
    }.toList)
    override def defaultValueValue: scala.Option[primitives.CostCategoryValue] = scala.Option(impl.defaultValue()).map(value => value: primitives.CostCategoryValue)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.CostCategory): ReadOnly = new Wrapper(impl)
}