package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class UtilizationByTime(timePeriod: scala.Option[DateInterval] = None, groups: scala.Option[Iterable[ReservationUtilizationGroup]] = None, total: scala.Option[ReservationAggregates] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.UtilizationByTime = {
    import UtilizationByTime.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.UtilizationByTime.builder().optionallyWith(timePeriod.map(value => value.buildAwsValue()))(_.timePeriod).optionallyWith(groups.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.groups).optionallyWith(total.map(value => value.buildAwsValue()))(_.total).build()
  }
  def asReadOnly: UtilizationByTime.ReadOnly = UtilizationByTime.wrap(buildAwsValue())
}
object UtilizationByTime {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.UtilizationByTime] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: UtilizationByTime = UtilizationByTime(timePeriodValue.map(value => value.editable), groupsValue.map(value => value.map { item => 
      item.editable
    }), totalValue.map(value => value.editable))
    def timePeriodValue: scala.Option[DateInterval.ReadOnly]
    def groupsValue: scala.Option[List[ReservationUtilizationGroup.ReadOnly]]
    def totalValue: scala.Option[ReservationAggregates.ReadOnly]
    def timePeriod: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DateInterval.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("timePeriod", timePeriodValue)
    def groups: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[ReservationUtilizationGroup.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("groups", groupsValue)
    def total: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ReservationAggregates.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("total", totalValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.UtilizationByTime) extends UtilizationByTime.ReadOnly {
    override def timePeriodValue: scala.Option[DateInterval.ReadOnly] = scala.Option(impl.timePeriod()).map(value => DateInterval.wrap(value))
    override def groupsValue: scala.Option[List[ReservationUtilizationGroup.ReadOnly]] = scala.Option(impl.groups()).map(value => value.asScala.map { item => 
      ReservationUtilizationGroup.wrap(item)
    }.toList)
    override def totalValue: scala.Option[ReservationAggregates.ReadOnly] = scala.Option(impl.total()).map(value => ReservationAggregates.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.UtilizationByTime): ReadOnly = new Wrapper(impl)
}