package io.github.vigoo.zioaws.costexplorer.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetDimensionValuesResponse(dimensionValues: Iterable[DimensionValuesWithAttributes], returnSize: primitives.PageSize, totalSize: primitives.PageSize, nextPageToken: scala.Option[primitives.NextPageToken] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.costexplorer.model.GetDimensionValuesResponse = {
    import GetDimensionValuesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.costexplorer.model.GetDimensionValuesResponse.builder().dimensionValues(dimensionValues.map { item => 
      item.buildAwsValue()
    }.asJavaCollection).returnSize(returnSize: java.lang.Integer).totalSize(totalSize: java.lang.Integer).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).build()
  }
  def asReadOnly: GetDimensionValuesResponse.ReadOnly = GetDimensionValuesResponse.wrap(buildAwsValue())
}
object GetDimensionValuesResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.costexplorer.model.GetDimensionValuesResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetDimensionValuesResponse = GetDimensionValuesResponse(dimensionValuesValue.map { item => 
      item.editable
    }, returnSizeValue, totalSizeValue, nextPageTokenValue.map(value => value))
    def dimensionValuesValue: List[DimensionValuesWithAttributes.ReadOnly]
    def returnSizeValue: primitives.PageSize
    def totalSizeValue: primitives.PageSize
    def nextPageTokenValue: scala.Option[primitives.NextPageToken]
    def dimensionValues: ZIO[Any, Nothing, List[DimensionValuesWithAttributes.ReadOnly]] = ZIO.succeed(dimensionValuesValue)
    def returnSize: ZIO[Any, Nothing, primitives.PageSize] = ZIO.succeed(returnSizeValue)
    def totalSize: ZIO[Any, Nothing, primitives.PageSize] = ZIO.succeed(totalSizeValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextPageToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.costexplorer.model.GetDimensionValuesResponse) extends GetDimensionValuesResponse.ReadOnly {
    override def dimensionValuesValue: List[DimensionValuesWithAttributes.ReadOnly] = impl.dimensionValues().asScala.map { item => 
      DimensionValuesWithAttributes.wrap(item)
    }.toList
    override def returnSizeValue: primitives.PageSize = impl.returnSize(): primitives.PageSize
    override def totalSizeValue: primitives.PageSize = impl.totalSize(): primitives.PageSize
    override def nextPageTokenValue: scala.Option[primitives.NextPageToken] = scala.Option(impl.nextPageToken()).map(value => value: primitives.NextPageToken)
  }
  def wrap(impl: software.amazon.awssdk.services.costexplorer.model.GetDimensionValuesResponse): ReadOnly = new Wrapper(impl)
}